/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.isc.iscb.platform.core.api.ApiInfo;
import kd.isc.iscb.util.dt.D;

public class ApiRounter {
    private static final LocalMemoryCache cache;

    public static void clearCache() {
        String accountId = RequestContext.get().getAccountId();
        cache.remove(new String[]{accountId});
    }

    public static List<ApiInfo> findApiInfos(long subscriber) {
        Map<Long, List<ApiInfo>> routerMap = ApiRounter.getRouterMap();
        List<ApiInfo> apiInfos = routerMap.get(subscriber);
        if (apiInfos == null) {
            apiInfos = ApiRounter.loadRouterMap(subscriber);
            routerMap.put(subscriber, apiInfos);
        }
        return apiInfos;
    }

    private static Map<Long, List<ApiInfo>> getRouterMap() {
        String accountId = RequestContext.get().getAccountId();
        ConcurrentHashMap routerMap = (ConcurrentHashMap)cache.get(accountId);
        if (routerMap == null) {
            routerMap = new ConcurrentHashMap();
            cache.put(accountId, routerMap);
        }
        return routerMap;
    }

    private static List<ApiInfo> loadRouterMap(long subscriber) {
        String sql = "SELECT A.fapi_type,A.fapi,A.fcaller,A.fformat_script,A.fformat_script_tag FROM t_isc_capi_by_mq A INNER JOIN t_iscb_mq_subscriber B ON A.fsubscriber = B.fid WHERE  A.fenable = ? and B.fid=?";
        Object[] params = new Object[]{"1", subscriber};
        List apiInfoList = (List)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, (Object[])params, rs -> {
            ArrayList<ApiInfo> ret = new ArrayList<ApiInfo>(1);
            while (rs.next()) {
                ret.add(ApiRounter.newApiInfo(rs));
            }
            return ret;
        });
        return apiInfoList;
    }

    private static ApiInfo newApiInfo(ResultSet rs) throws SQLException {
        String metaNumber = rs.getString(1);
        long apiId = rs.getLong(2);
        long callerId = rs.getLong(3);
        String formatScript = rs.getString(4);
        String formatScriptTag = rs.getString(5);
        String scriptStr = D.s((Object)formatScriptTag);
        if (scriptStr == null) {
            scriptStr = D.s((Object)formatScript);
        }
        return new ApiInfo(metaNumber, apiId, callerId, scriptStr);
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(512);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_MQ_API", "bd", info);
    }
}

