/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.misc.StringUtil;

public class FilterUtil {
    public static boolean matches(String str, Map<String, Object> data) {
        Filter filter = FilterUtil.parseFilter(str, data);
        return filter == null || filter.matches(data);
    }

    public static Filter parseFilter(String str, Map<String, Object> data) {
        if (StringUtil.isEmpty((String)str) || CollectionUtils.isEmpty(data)) {
            return null;
        }
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>(10);
        while (true) {
            String link;
            int separator = (link = FilterUtil.findLink(str)) == null ? str.length() : str.indexOf(link);
            FilterUtil.addFilter(filterList, data, str.substring(0, separator), link);
            if (link == null) break;
            str = str.substring(separator + 1 + link.length());
        }
        return new Filter(filterList);
    }

    private static String findLink(String str) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("and", str.indexOf("and"));
        map.put("AND", str.indexOf("AND"));
        map.put("or", str.indexOf("or"));
        map.put("OR", str.indexOf("OR"));
        return FilterUtil.findMinKey(map);
    }

    private static void addFilter(List<Map<String, Object>> filterList, Map<String, Object> data, String str, String link) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        String compareType = FilterUtil.findCompareType(str);
        int index = str.indexOf(compareType);
        FilterUtil.setLeft(filter, str.substring(0, index), data);
        filter.put("filter_compare", compareType);
        FilterUtil.setRight(filter, str.substring(index + compareType.length()));
        if (link != null) {
            filter.put("filter_link", link.toUpperCase());
        }
        filterList.add(filter);
    }

    private static void setLeft(Map<String, Object> filter, String s, Map<String, Object> data) {
        char[] chars = s.toCharArray();
        String bracket = "";
        String field = s;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (chars[i] != '(') continue;
            bracket = s.substring(0, i + 1).trim();
            if (i < s.length() - 1) {
                field = s.substring(i + 1).trim();
                break;
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f%s\u4e0d\u5408\u6cd5!", (String)"FilterUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        if (!data.containsKey(field.trim())) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728!", (String)"FilterUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field));
        }
        filter.put("filter_left_bracket", bracket);
        filter.put("filter_column", field);
    }

    private static void setRight(Map<String, Object> filter, String s) {
        char[] chars = s.toCharArray();
        String value = s;
        String bracket = "";
        for (int i = 0; i < s.length(); ++i) {
            if (chars[i] != ')') continue;
            value = s.substring(0, i).trim();
            bracket = s.substring(i).trim();
            if (value.length() != 0) continue;
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f%s\u4e0d\u5408\u6cd5!", (String)"FilterUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s));
        }
        filter.put("filter_value", value);
        filter.put("filter_right_bracket", bracket);
    }

    private static String findCompareType(String str) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("=", str.indexOf(61));
        map.put("!=", str.indexOf("!="));
        map.put("<>", str.indexOf("<>"));
        map.put(">", str.indexOf(62));
        map.put("<", str.indexOf(60));
        map.put(">=", str.indexOf(">="));
        map.put("<=", str.indexOf("<="));
        map.put("is null", str.indexOf("is null"));
        map.put("not null", str.indexOf("not null"));
        map.put("like", str.indexOf("like"));
        map.put("STARTS_WITH", str.indexOf("STARTS_WITH"));
        map.put("ENDS_WITH", str.indexOf("ENDS_WITH"));
        map.put("CONTAINS", str.indexOf("CONTAINS"));
        String key = FilterUtil.findMinKey(map);
        if (key == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6bd4\u8f83\u7b26\u53f7.", (String)"FilterUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return key;
    }

    private static String findMinKey(Map<String, Integer> map) {
        int min = Integer.MAX_VALUE;
        String key = null;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Integer value = entry.getValue();
            if (value >= min || value < 0) continue;
            min = value;
            key = entry.getKey();
        }
        return key;
    }
}

