/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.data.fsm.FSM;

public class MessageConsumer {
    private static Log logger = LogFactory.getLog(MessageConsumer.class);

    public static void init() {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            MessageConsumer.initAllListeners(cn);
        }
        catch (Throwable e) {
            try {
                logger.warn("MessageConsumer init failed.", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(cn, (boolean)false);
                throw throwable;
            }
            DbUtil.close((Connection)cn, (boolean)false);
        }
        DbUtil.close((Connection)cn, (boolean)false);
    }

    private static void initAllListeners(Connection cn) {
        String sql = "SELECT fid, fnumber, fsub_ip_perttern, fmq_server, fparse_script,  fparse_script_tag, fcharset, fmsg_digest, fcustom_config FROM t_iscb_mq_subscriber WHERE fenable='1'";
        MessageConsumer.attachListeners(cn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachListeners(long mqServer) {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            String sql = "SELECT fid, fnumber, fsub_ip_perttern, fmq_server, fparse_script,  fparse_script_tag, fcharset, fmsg_digest, fcustom_config FROM t_iscb_mq_subscriber WHERE fenable='1' AND fmq_server=" + mqServer;
            MessageConsumer.attachListeners(cn, sql);
        }
        catch (Throwable e) {
            try {
                logger.warn("MessageConsumer init failed.", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(cn, (boolean)false);
                throw throwable;
            }
            DbUtil.close((Connection)cn, (boolean)false);
        }
        DbUtil.close((Connection)cn, (boolean)false);
    }

    private static void attachListeners(Connection cn, String sql) {
        List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        List ip_addresses = NetUtil.getIpAddresses();
        for (DataRow item : list) {
            String pattern = D.s((Object)item.get((Object)"fsub_ip_perttern"));
            if (!MessageConsumer.matches(pattern, ip_addresses)) continue;
            MessageConsumer.innerAttachListener(item);
        }
    }

    private static void innerAttachListener(DataRow item) {
        try {
            String topic = D.s((Object)item.get((Object)"fnumber"));
            long server = D.l((Object)item.get((Object)"fmq_server"));
            long subscriber = D.l((Object)item.get((Object)"fid"));
            Charset charset = Charset.forName(D.s((Object)item.get((Object)"fcharset")));
            String parseScript = MessageConsumer.getParseScript(item);
            String msgDigestScript = D.s((Object)item.get((Object)"fmsg_digest"));
            String customConfig = D.s((Object)item.get((Object)"fcustom_config"));
            MessageQueueServer messageQueueServer = MessageQueueManager.get(server);
            MessageReceiver receiver = new MessageReceiver(topic, subscriber, messageQueueServer, server, charset, parseScript, msgDigestScript);
            if (StringUtil.isEmpty((String)customConfig)) {
                messageQueueServer.attachListener(topic, receiver);
            } else {
                messageQueueServer.attachListener(topic, receiver, customConfig);
            }
        }
        catch (Throwable e) {
            logger.warn("MessageConsumer (" + item.get((Object)"fnumber") + ") init failed.", e);
        }
    }

    public static boolean matches(String pattern, List<String> ip_addresses) {
        if (pattern == null || ip_addresses.isEmpty()) {
            return true;
        }
        FSM fsm = new FSM();
        for (String s : pattern.split(",")) {
            fsm.add("^" + s + "$");
        }
        for (String ip : ip_addresses) {
            if (!fsm.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private static String getParseScript(DataRow item) {
        String parseScript = D.s((Object)item.get((Object)"fparse_script_tag"));
        if (parseScript == null) {
            parseScript = D.s((Object)item.get((Object)"fparse_script"));
        }
        return parseScript;
    }
}

