/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class TriggerRouter {
    private static final LocalMemoryCache cache;

    public static List<Long> findTrigger(long subscriber, Map<String, Object> data) {
        Map<Long, Map<Long, Filter>> routerMap = TriggerRouter.getRouterMap();
        Map<Long, Filter> triggerMap = routerMap.get(subscriber);
        if (triggerMap == null) {
            triggerMap = TriggerRouter.loadRouterMap(subscriber);
            routerMap.put(subscriber, triggerMap);
        }
        ArrayList<Long> triggers = new ArrayList<Long>(triggerMap.size());
        for (Map.Entry<Long, Filter> e : triggerMap.entrySet()) {
            if (!e.getValue().matches(data)) continue;
            triggers.add(e.getKey());
        }
        return triggers;
    }

    public static void clearCache() {
        String accountId = RequestContext.get().getAccountId();
        cache.remove(new String[]{accountId});
    }

    private static Map<Long, Map<Long, Filter>> getRouterMap() {
        String accountId = RequestContext.get().getAccountId();
        Map routerMap = (Map)cache.get(accountId);
        if (routerMap == null) {
            routerMap = new ReadLockFreeMap();
            cache.put(accountId, (Object)routerMap);
        }
        return routerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, Filter> loadRouterMap(long subscriber) {
        String sql = "SELECT A.fid FROM t_isc_data_copy_trigger A INNER JOIN t_iscb_mq_subscriber B ON A.fsubscriber_queue = B.fid WHERE A.fsource_protocal = 'MQ' and A.fenable = '1' and B.fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(subscriber), Collections.singletonList(-5));
            HashMap<Long, Filter> triggerMap = new HashMap<Long, Filter>(0);
            for (DataRow row : list) {
                Long trigger = D.l((Object)row.get((Object)"fid"));
                DynamicObject t = BusinessDataServiceHelper.loadSingle((Object)trigger, (String)"isc_data_copy_trigger");
                DataCopyParam param = new DataCopyParam(t);
                List<Map<String, Object>> items = param.prepareFilter();
                Filter filter = new Filter(items);
                triggerMap.put(trigger, filter);
            }
            HashMap<Long, Filter> hashMap = triggerMap;
            return hashMap;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(512);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_MQ_TR", "bd", info);
    }
}

