/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.kafka;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaUtil;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class KafkaConsumerTask
implements Runnable {
    private static Log logger = LogFactory.getLog(KafkaConsumerTask.class);
    private final MessageReceiver receiver;
    private final String bootstrapServers;
    private final String groupId;
    private final String topic;
    private final Map<String, Object> configs = new HashMap<String, Object>();
    private final DynamicObject cfg;
    private volatile boolean pauseFlag = false;

    public KafkaConsumerTask(String bootstrapServers, String groupId, String topic, MessageReceiver receiver, DynamicObject cfg) {
        this.bootstrapServers = bootstrapServers;
        this.groupId = groupId;
        this.topic = topic;
        this.receiver = receiver;
        this.cfg = cfg;
        this.initConsumerConfig();
    }

    public KafkaConsumerTask(String bootstrapServers, String groupId, String topic, MessageReceiver receiver, DynamicObject cfg, String customParam) {
        this(bootstrapServers, groupId, topic, receiver, cfg);
        KafkaUtil.setCustomParam(this.configs, customParam);
    }

    private void initConsumerConfig() {
        this.configs.put("bootstrap.servers", this.bootstrapServers);
        this.configs.put("group.id", this.groupId);
        this.configs.put("enable.auto.commit", Boolean.FALSE);
        this.configs.put("auto.commit.interval.ms", "1000");
        this.configs.put("max.poll.records", "10");
        this.configs.put("session.timeout.ms", "10000");
        this.configs.put("heartbeat.interval.ms", "3000");
        this.configs.put("max.poll.interval.ms", "300000");
        this.configs.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.configs.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        KafkaUtil.checkSaslJaas(this.configs, this.cfg);
    }

    @Override
    public void run() {
        KafkaConsumer consumer = new KafkaConsumer(this.configs);
        consumer.subscribe(Collections.singletonList(this.topic));
        while (!this.pauseFlag) {
            ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
            for (ConsumerRecord record : records) {
                try {
                    logger.info("receive success." + record);
                    this.receiver.handleMessage((byte[])record.value());
                }
                catch (Exception e) {
                    logger.warn("failed to handle message." + record, (Throwable)e);
                }
            }
            try {
                consumer.commitSync();
            }
            catch (Exception e) {
                logger.warn("failed to commitSync offset.", (Throwable)e);
            }
        }
        try {
            consumer.close();
        }
        catch (Exception e) {
            logger.warn("failed to close consumer." + this.toString(), (Throwable)e);
        }
    }

    public void pause() {
        this.pauseFlag = true;
    }

    public String toString() {
        return "KafkaConsumerTask{bootstrapServers='" + this.bootstrapServers + '\'' + ", groupId='" + this.groupId + '\'' + ", topic='" + this.topic + '\'' + '}';
    }
}

