/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.kafka;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaCallback;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaConsumerTask;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaThreadPool;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaServer
implements MessageQueueServer {
    private static Log logger = LogFactory.getLog(KafkaServer.class);
    private Map<String, Publisher> publishers = new ReadLockFreeMap();
    private Map<String, KafkaConsumerTask> consumers = new HashMap<String, KafkaConsumerTask>();
    private AdminClient adminClient;
    private DynamicObject cfg;
    private String bootstrapServers;
    private int numPartitions = 1;
    private int numReplication = 1;

    public KafkaServer(AdminClient adminClient, DynamicObject cfg, String bootstrapServers, int brokerNum) {
        this.adminClient = adminClient;
        this.cfg = cfg;
        this.bootstrapServers = bootstrapServers;
        if (brokerNum > 1) {
            this.numPartitions = brokerNum;
            this.numReplication = brokerNum;
        }
    }

    @Override
    public DynamicObject getConfig() {
        return this.cfg;
    }

    @Override
    public long getId() {
        return D.l((Object)this.cfg.getPkValue());
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver) {
        if (this.consumers.containsKey(topic)) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"Kafka\u4e3b\u9898\uff08%s\uff09\u5df2\u8ba2\u9605\uff01", (String)"KafkaServer_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), topic));
        }
        KafkaConsumerTask consumer = new KafkaConsumerTask(this.bootstrapServers, topic, topic, receiver, this.cfg);
        KafkaThreadPool.execute(consumer);
        this.consumers.put(topic, consumer);
        logger.info("Kafka\u4e3b\u9898\uff08" + topic + "\uff09\u6d88\u8d39\u8005\u521b\u5efa\u6210\u529f");
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver, String customParam) {
        if (this.consumers.containsKey(topic)) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"Kafka\u4e3b\u9898\uff08%s\uff09\u5df2\u8ba2\u9605\uff01", (String)"KafkaServer_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), topic));
        }
        KafkaConsumerTask consumer = new KafkaConsumerTask(this.bootstrapServers, topic, topic, receiver, this.cfg, customParam);
        KafkaThreadPool.execute(consumer);
        this.consumers.put(topic, consumer);
        logger.info("Kafka\u4e3b\u9898\uff08" + topic + "\uff09\u6d88\u8d39\u8005\u521b\u5efa\u6210\u529f");
    }

    @Override
    public synchronized void detachListeners() {
        Iterator<Map.Entry<String, KafkaConsumerTask>> it = this.consumers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, KafkaConsumerTask> e = it.next();
            it.remove();
            KafkaConsumerTask consumer = e.getValue();
            try {
                consumer.pause();
            }
            catch (Exception err) {
                logger.warn("failed to close KafkaConsumerTask. KafkaConsumerTask = " + consumer, (Throwable)err);
            }
        }
    }

    @Override
    public void publish(String topic, PublishedMessage msg) {
        Publisher producer = this.getProducer(topic, null);
        producer.send(msg);
    }

    @Override
    public void publish(String topic, PublishedMessage msg, String customParam) {
        Publisher producer = this.getProducer(topic, customParam);
        producer.send(msg);
    }

    private Publisher getProducer(String topic, String customParam) {
        Publisher p = this.publishers.get(topic);
        if (p != null) {
            return p;
        }
        return this.createPublisher(topic, customParam);
    }

    private synchronized Publisher createPublisher(String topic, String customParam) {
        Publisher p = this.publishers.get(topic);
        if (p == null) {
            p = new Publisher(topic, this.bootstrapServers, this.cfg, customParam);
            this.publishers.put(topic, p);
        }
        return p;
    }

    private static class Publisher {
        private KafkaProducer<String, byte[]> producer;
        private String topic;
        private String bootstrapServers;
        private DynamicObject cfg;
        private String customParam;

        private Publisher(String topic, String bootstrapServers, DynamicObject cfg, String customParam) {
            this.topic = topic;
            this.bootstrapServers = bootstrapServers;
            this.cfg = cfg;
            this.customParam = customParam;
            this.producer = this.createProducer();
        }

        private KafkaProducer<String, byte[]> createProducer() {
            return this.innerCreateProducer();
        }

        private KafkaProducer<String, byte[]> innerCreateProducer() {
            HashMap<String, Object> configs = new HashMap<String, Object>(4);
            configs.put("bootstrap.servers", this.bootstrapServers);
            configs.put("acks", "all");
            configs.put("linger.ms", "1000");
            configs.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            configs.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            KafkaUtil.checkSaslJaas(configs, this.cfg);
            KafkaUtil.setCustomParam(configs, this.customParam);
            return new KafkaProducer(configs);
        }

        private void send(PublishedMessage msg) {
            if (this.producer == null) {
                this.producer = this.createProducer();
                logger.info("Kafka\u4e3b\u9898\uff08" + this.topic + "\uff09\u751f\u4ea7\u8005\u521b\u5efa\u6210\u529f");
            }
            this.publish(msg);
        }

        private void publish(PublishedMessage msg) {
            this.producer.send(new ProducerRecord(this.topic, (Object)msg.getData()), (Callback)new KafkaCallback(msg));
            this.producer.flush();
            logger.info("Kafka\u4e3b\u9898\uff08" + this.topic + "\uff09\u53d1\u9001\u6d88\u606f\u6210\u529f");
        }
    }
}

