/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.kafka;

import com.sun.security.auth.module.Krb5LoginModule;
import java.util.Map;
import javax.security.auth.spi.LoginModule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;

public class KafkaUtil {
    private static final String SASL_P = "password";

    public static void setCustomParam(Map<String, Object> configs, String customParam) {
        Map customMap = (Map)Json.toObject((String)customParam);
        if (customMap != null) {
            customMap.remove("bootstrap.servers");
            configs.putAll(customMap);
        }
    }

    public static void checkSaslJaas(Map<String, Object> configs, DynamicObject cfg) {
        String username = D.s((Object)cfg.get("user"));
        String password = D.s((Object)cfg.get(SASL_P));
        if (StringUtils.isEmpty((String)username)) {
            return;
        }
        String mechanismProtocol = D.s((Object)cfg.get("mechanism_protocol"));
        if (StringUtils.isEmpty((String)password) && !"OAUTHBEARER".equals(mechanismProtocol)) {
            return;
        }
        String securityProtocol = D.s((Object)cfg.get("security_protocol"));
        if (StringUtils.isEmpty((String)securityProtocol)) {
            securityProtocol = "SASL_PLAINTEXT";
        }
        if (StringUtils.isEmpty((String)mechanismProtocol)) {
            mechanismProtocol = "PLAIN";
        }
        configs.put("security.protocol", securityProtocol);
        configs.put("sasl.mechanism", mechanismProtocol);
        KafkaUtil.setConfig(configs, cfg, username, password, mechanismProtocol);
    }

    private static void setConfig(Map<String, Object> configs, DynamicObject cfg, String username, String password, String mechanismProtocol) {
        switch (mechanismProtocol) {
            case "PLAIN": {
                KafkaUtil.setSaslJaasConfig(configs, PlainLoginModule.class, username, password);
                break;
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-512": {
                KafkaUtil.setSaslJaasConfig(configs, ScramLoginModule.class, username, password);
                break;
            }
            case "OAUTHBEARER": {
                configs.put("sasl.jaas.config", OAuthBearerLoginModule.class.getName() + " required  unsecuredLoginStringClaim_sub=\"" + username + "\";");
                break;
            }
            case "GSSAPI": {
                configs.put("sasl.jaas.config", Krb5LoginModule.class.getName() + " required useKeyTab=true storeKey=true useTicketCache=true keyTab=\"" + password + "\"  principal=\"" + username + "\";");
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u534f\u8bae\u673a\u5236\uff1a%s", (String)"KafkaUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), mechanismProtocol));
            }
        }
    }

    private static void setSaslJaasConfig(Map<String, Object> configs, Class<? extends LoginModule> securityClass, String username, String password) {
        configs.put("sasl.jaas.config", securityClass.getName() + " required username=\"" + username + "\" " + SASL_P + "=\"" + password + "\";");
    }
}

