/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.mqs;

import com.huawei.it.eip.ump.client.consumer.Consumer;
import com.huawei.it.eip.ump.client.listener.MessageListener;
import com.huawei.it.eip.ump.client.producer.Producer;
import com.huawei.it.eip.ump.client.producer.SendResult;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.message.Message;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import kd.isc.iscb.platform.core.dc.mq.mqs.MqsMessageListener;
import kd.isc.iscb.platform.core.dc.mq.rocketmq.RocketMqServer;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class MqsServer
implements MessageQueueServer {
    private static final Log LOG = LogFactory.getLog(MqsServer.class);
    private final DynamicObject cfg;
    private final Map<String, Producer> producers = new ReadLockFreeMap();
    private final Map<String, Consumer> consumers = new HashMap<String, Consumer>();

    public MqsServer(DynamicObject cfg) {
        this.cfg = cfg;
    }

    @Override
    public DynamicObject getConfig() {
        return this.cfg;
    }

    @Override
    public long getId() {
        return D.l((Object)this.cfg.getPkValue());
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver) {
        if (this.consumers.containsKey(topic)) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"MQS\u4e3b\u9898\uff08%s\uff09\u5df2\u8ba2\u9605\uff01", (String)"MqsServer_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), topic));
        }
        try {
            Consumer consumer = this.createConsumer(topic, receiver);
            this.consumers.put(topic, consumer);
        }
        catch (UmpException e) {
            String name = this.cfg.getString("name");
            String number = this.cfg.getString("number");
            throw ConnectorError.MQS_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, StringUtil.getMessage((Throwable)e)});
        }
    }

    @Override
    public synchronized void detachListeners() {
        Iterator<Map.Entry<String, Consumer>> iterator = this.consumers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Consumer> entry = iterator.next();
            iterator.remove();
            Consumer consumer = entry.getValue();
            if (consumer == null) continue;
            try {
                consumer.shutdown();
            }
            catch (Exception e) {
                LOG.warn("failed to close consumer. consumer = " + consumer, (Throwable)e);
            }
        }
    }

    @Override
    public void publish(String topicTagFlag, PublishedMessage msg) {
        block7: {
            RocketMqServer.TopicTagData topicTag = new RocketMqServer.TopicTagData(topicTagFlag, null);
            String topic = topicTag.getTopic();
            String tag = topicTag.getTag();
            Producer producer = this.getProducer(topic);
            Message message = new Message();
            message.setBusinessId(D.s((Object)msg.getId()));
            message.setTags(tag);
            message.setBody(msg.getData());
            try {
                SendResult sendResult = producer.send(message);
                if (sendResult.isSuccess()) {
                    try {
                        msg.setSuccess();
                    }
                    catch (Exception e) {
                        LOG.warn("onCompletion setSuccess failed. id=" + msg.getId(), (Throwable)e);
                    }
                    break block7;
                }
                throw new IscBizException(sendResult.toString());
            }
            catch (Exception e) {
                try {
                    msg.setFailed(e);
                }
                catch (Exception exception) {
                    LOG.warn("onCompletion setFailed failed. id=" + msg.getId(), (Throwable)exception);
                }
                throw ConnectorError.MQ_PUBLISH_MESSAGE_FAILURE.wrap((Throwable)e);
            }
        }
    }

    private Producer getProducer(String topic) {
        Producer p = this.producers.get(topic);
        if (p != null) {
            return p;
        }
        return this.createPublisher(topic);
    }

    private synchronized Producer createPublisher(String topic) {
        Producer producer = this.producers.get(topic);
        if (producer == null) {
            producer = new Producer();
            producer.setUmpNamesrvUrls(D.s((Object)this.cfg.get("bootstrap_servers")).replace(" ", "").replace(',', ';'));
            producer.setAppId(D.s((Object)this.cfg.get("user")));
            producer.setAppSecret(D.s((Object)this.cfg.get("password")));
            producer.setInstanceName(topic + System.currentTimeMillis());
            producer.setTopic(topic);
            producer.setEncryptTransport(this.cfg.getBoolean("encrypt_transport"));
            try {
                producer.start();
            }
            catch (UmpException e) {
                try {
                    producer.shutdown();
                }
                catch (UmpException umpException) {
                    LOG.warn("failed to close Producer. Producer = " + producer, (Throwable)e);
                }
                String name = this.cfg.getString("name");
                String number = this.cfg.getString("number");
                throw ConnectorError.MQS_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, e.getMessage()});
            }
            this.producers.put(topic, producer);
        }
        return producer;
    }

    private Consumer createConsumer(String topicTagFlag, MessageReceiver receiver) throws UmpException {
        RocketMqServer.TopicTagData topicTag = new RocketMqServer.TopicTagData(topicTagFlag, "*");
        String topic = topicTag.getTopic();
        String tag = topicTag.getTag();
        Consumer consumer = new Consumer();
        consumer.setUmpNamesrvUrls(D.s((Object)this.cfg.get("bootstrap_servers")).replace(" ", "").replace(',', ';'));
        consumer.setAppId(D.s((Object)this.cfg.get("user")));
        consumer.setAppSecret(D.s((Object)this.cfg.get("password")));
        consumer.setInstanceName(topic + System.currentTimeMillis());
        consumer.setTopic(topic);
        consumer.setTags(tag);
        consumer.setEncryptTransport(this.cfg.getBoolean("encrypt_transport"));
        consumer.setSubGroup(topicTag.getGroup());
        consumer.subscribe((MessageListener)new MqsMessageListener(receiver));
        consumer.start();
        return consumer;
    }
}

