/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;

final class MessageConsumer
implements Consumer {
    private static Log logger = LogFactory.getLog(MessageConsumer.class);
    private MessageReceiver receiver;
    private Channel channel;

    public MessageConsumer(Channel channel, MessageReceiver receiver) {
        this.channel = channel;
        this.receiver = receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties properties, byte[] body) {
        try {
            this.receiver.handleMessage(body);
        }
        catch (Throwable e) {
            logger.warn("failed to handle message.", e);
        }
        finally {
            MessageConsumer.ack(this.channel, env);
        }
    }

    private static void ack(Channel channel, Envelope env) {
        try {
            channel.basicAck(env.getDeliveryTag(), false);
        }
        catch (Throwable e) {
            logger.warn("failed to ack invocation delivery.", e);
        }
    }

    public void handleCancel(String consumerTag) throws IOException {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleConsumeOk(String consumerTag) {
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException e) {
    }
}

