/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rocketmq;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.cache.data.PublishTopicSchema;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import kd.isc.iscb.platform.core.dc.mq.rocketmq.RocketMessageListener;
import kd.isc.iscb.platform.core.dc.mq.rocketmq.RocketSendCallback;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public class RocketMqServer
implements MessageQueueServer {
    private static final String BOOTSTRAP_SERVERS = "bootstrap_servers";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final Log LOG = LogFactory.getLog(RocketMqServer.class);
    private final DynamicObject cfg;
    private final Map<String, DefaultMQProducer> producers = new ReadLockFreeMap();
    private final Map<String, DefaultMQPushConsumer> consumers = new HashMap<String, DefaultMQPushConsumer>();

    public RocketMqServer(DynamicObject cfg) {
        this.cfg = cfg;
        this.checkRocketMq(cfg);
    }

    @Override
    public DynamicObject getConfig() {
        return this.cfg;
    }

    @Override
    public long getId() {
        return D.l((Object)this.cfg.getPkValue());
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver) {
        if (this.consumers.containsKey(topic)) {
            throw new UnsupportedOperationException(String.format(String.format(ResManager.loadKDString((String)"RocketMQ\u4e3b\u9898\uff08%s\uff09\u5df2\u8ba2\u9605\uff01", (String)"RocketMqServer_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), topic), new Object[0]));
        }
        try {
            DefaultMQPushConsumer consumer = this.createConsumer(topic, receiver);
            this.consumers.put(topic, consumer);
        }
        catch (Exception e) {
            String name = this.cfg.getString(NAME);
            String number = this.cfg.getString(NUMBER);
            throw ConnectorError.ROCKET_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, StringUtil.getMessage((Throwable)e)});
        }
    }

    @Override
    public synchronized void detachListeners() {
        Iterator<Map.Entry<String, DefaultMQPushConsumer>> iterator = this.consumers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DefaultMQPushConsumer> entry = iterator.next();
            iterator.remove();
            DefaultMQPushConsumer consumer = entry.getValue();
            if (consumer == null) continue;
            try {
                consumer.shutdown();
            }
            catch (Exception e) {
                LOG.warn("failed to close consumer. consumer = " + consumer, (Throwable)e);
            }
        }
    }

    @Override
    public void publish(String topicTagFlag, PublishedMessage msg) {
        TopicTagData topicTag = new TopicTagData(topicTagFlag, null);
        String topic = topicTag.getTopic();
        String tag = topicTag.getTag();
        String group = topicTag.getGroup();
        DefaultMQProducer producer = this.getProducer(topic, group);
        Message message = new Message(topic, tag, msg.getData());
        message.setKeys(D.s((Object)msg.getId()));
        int delayTime = this.getDelayTime(topicTagFlag);
        if (delayTime != -1) {
            message.setDelayTimeLevel(delayTime);
        }
        try {
            producer.send(message, (SendCallback)new RocketSendCallback(msg));
        }
        catch (Exception e) {
            msg.setFailed(e);
            throw ConnectorError.MQ_PUBLISH_MESSAGE_FAILURE.wrap((Throwable)e);
        }
    }

    private int getDelayTime(String topic) {
        DynamicObject publish = PublishTopicSchema.get(topic).getConfig();
        String dbDelayTime = publish.getString("delay_time");
        if (D.s((Object)dbDelayTime) == null) {
            return -1;
        }
        return Integer.parseInt(dbDelayTime);
    }

    private DefaultMQPushConsumer createConsumer(String topicTagFlag, MessageReceiver receiver) throws MQClientException {
        TopicTagData topicTag = new TopicTagData(topicTagFlag, "*");
        String topic = topicTag.getTopic();
        String tag = topicTag.getTag();
        String group = topicTag.getGroup();
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(group, this.createRpcHook(), (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        consumer.setNamesrvAddr(D.s((Object)this.cfg.get(BOOTSTRAP_SERVERS)).replace(" ", "").replace(',', ';'));
        consumer.subscribe(topic, tag);
        consumer.setConsumeThreadMin(1);
        consumer.setConsumeThreadMax(20);
        consumer.setPullInterval(1000L);
        consumer.registerMessageListener((MessageListenerConcurrently)new RocketMessageListener(receiver));
        consumer.setConsumeMessageBatchMaxSize(1);
        consumer.setInstanceName(topic + System.currentTimeMillis());
        consumer.start();
        return consumer;
    }

    private RPCHook createRpcHook() {
        String accessKey = D.s((Object)this.cfg.get("user"));
        String secretKey = D.s((Object)this.cfg.get("password"));
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)secretKey)) {
            return new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
        }
        return null;
    }

    private DefaultMQProducer getProducer(String topic, String group) {
        DefaultMQProducer p = this.producers.get(topic);
        if (p != null) {
            return p;
        }
        return this.createPublisher(topic, group);
    }

    private synchronized DefaultMQProducer createPublisher(String topic, String group) {
        DefaultMQProducer producer = this.producers.get(topic);
        if (producer == null) {
            producer = new DefaultMQProducer(topic, this.createRpcHook());
            if (!StringUtil.isEmpty((String)group)) {
                producer.setProducerGroup(group);
            }
            producer.setNamesrvAddr(D.s((Object)this.cfg.get(BOOTSTRAP_SERVERS)).replace(" ", "").replace(',', ';'));
            producer.setInstanceName(topic + System.currentTimeMillis());
            producer.setRetryTimesWhenSendAsyncFailed(0);
            try {
                producer.start();
            }
            catch (MQClientException e) {
                producer.shutdown();
                String name = this.cfg.getString(NAME);
                String number = this.cfg.getString(NUMBER);
                throw ConnectorError.ROCKET_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, e.getMessage()});
            }
            this.producers.put(topic, producer);
        }
        return producer;
    }

    private void checkRocketMq(DynamicObject cfg) {
        DefaultMQAdminExt defaultMQAdminExt = null;
        try {
            defaultMQAdminExt = new DefaultMQAdminExt(this.createRpcHook());
            defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
            defaultMQAdminExt.setNamesrvAddr(D.s((Object)cfg.get(BOOTSTRAP_SERVERS)).replace(" ", "").replace(',', ';'));
            defaultMQAdminExt.start();
            defaultMQAdminExt.fetchAllTopicList();
        }
        catch (InterruptedException | MQClientException | RemotingException e) {
            String name = cfg.getString(NAME);
            String number = cfg.getString(NUMBER);
            throw ConnectorError.ROCKET_CONNECT_ERROR.create(e, new String[]{name, number, e.getMessage()});
        }
        finally {
            if (defaultMQAdminExt != null) {
                defaultMQAdminExt.shutdown();
            }
        }
    }

    public static class TopicTagData {
        private String topic;
        private String tag;
        private String group;

        public TopicTagData(String topicTag, String defaultTag) {
            this.tag = defaultTag;
            int i = topicTag.indexOf("::");
            if (i > 0) {
                this.group = topicTag.substring(0, i);
                topicTag = topicTag.substring(i + 2);
            }
            this.topic = topicTag;
            if (topicTag.contains("@")) {
                String[] topicTags = topicTag.split("@", 2);
                this.topic = topicTags[0];
                this.tag = topicTags[1];
            }
        }

        public String getTopic() {
            return this.topic;
        }

        public String getTag() {
            return this.tag;
        }

        public String getGroup() {
            return this.group;
        }
    }
}

