/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.s;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;

public enum CallbackAppendType {
    $SRC_BILL_INFO(1){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object initAppendInfo(DynamicObject execution) {
            try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
                String sql = "select foid,fnumber,fstatus from t_iscb_bill_log_relation where ftask = ? and frole = '1'";
                List<Long> values = Collections.singletonList(execution.getLong("id"));
                List<Integer> types = Collections.singletonList(-5);
                List rows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
                ArrayList billList = new ArrayList(rows.size());
                for (DataRow row : rows) {
                    HashMap<String, Object> billInfo = new HashMap<String, Object>();
                    billInfo.put("oid", row.get((Object)"foid"));
                    billInfo.put("number", row.get((Object)"fnumber"));
                    billInfo.put("status", row.get((Object)"fstatus"));
                    billList.add(billInfo);
                }
                ArrayList arrayList = billList;
                return arrayList;
            }
            catch (SQLException e) {
                throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{"ISCB"});
            }
        }
    };

    private final int value;

    private CallbackAppendType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public abstract Object initAppendInfo(DynamicObject var1);
}

