/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.s;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.s.AbstractTriggerFinder;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.util.bean.EachTriggerInfo;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ServiceFlowTriggerFinder
extends AbstractTriggerFinder {
    protected ServiceFlowTriggerFinder(long dbLinkId) {
        super(dbLinkId);
    }

    @Override
    protected EachTriggerInfo makeEventTriggerInfo(DynamicObject justId) {
        long flowDefId = justId.getLong("id");
        long releasedFlowId = ServiceFlowParser.findReleasedFlowId(flowDefId);
        if (releasedFlowId > 0L) {
            Flow releaseFlow = ServiceFlowParser.getFlow(releasedFlowId);
            EventStarterParser.EventStarter eventStarter = (EventStarterParser.EventStarter)ServiceFlowParser.getStarter(releaseFlow);
            Map<String, Object> nodeInfo = eventStarter.getNodeInfo();
            DynamicObject meta = MetaDataSchema.get(D.l((Object)nodeInfo.get("data_schema")));
            String s = D.s((Object)eventStarter.getNodeInfo().get("bill_events"));
            Object[] events = s == null ? new String[]{} : s.split(",");
            String entity = meta.getString("full_name");
            long dataSourceId = meta.getLong("group_id");
            long dbLink = DataSource.get(dataSourceId).getDbLink();
            if (dbLink == this.dbLinkId) {
                EachTriggerInfo eachTriggerInfo = new EachTriggerInfo();
                eachTriggerInfo.setEvents(StringUtil.join((Object[])events));
                eachTriggerInfo.setEntity(entity);
                List selectorEntry = (List)nodeInfo.get("selector_entry");
                DynamicObject serviceFlow = BusinessDataServiceHelper.loadSingle((Object)flowDefId, (String)"isc_service_flow");
                EventBindingUtil.checkParams((String[])events, this.initRequiresMap(selectorEntry), (String)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"ServiceFlowTriggerFinder_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (String)serviceFlow.getString("number"), (String)serviceFlow.getString("name"));
                eachTriggerInfo.setRequires(Json.toString(this.initRequiresMap(selectorEntry)));
                eachTriggerInfo.setTriggerId(flowDefId);
                eachTriggerInfo.setTriggerType(EventBindingUtil.TriggerType.ServiceFlowTrigger);
                return eachTriggerInfo;
            }
        }
        return null;
    }

    @Override
    protected DynamicObject[] getTriggerIds(long dbLinkId) {
        QFilter qFilter = new QFilter("init_mode", "=", (Object)"EVENT");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] justIds = BusinessDataServiceHelper.load((String)"isc_service_flow", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");
        return justIds;
    }

    private Map<String, Object> initRequiresMap(List<Map<String, Object>> selectorEntry) {
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectorEntry.size());
        for (Map<String, Object> selector : selectorEntry) {
            String field = D.s((Object)selector.get("field"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, path);
        }
        return requires;
    }
}

