/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.debug;

import java.lang.constant.Constable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.instance.Instance;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.debug.ScriptDebugSignal;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Hash;
import kd.isc.iscb.util.script.feature.control.loop.Throw;

public class ScriptDebugCoordinator
implements DebugCoordinator {
    public boolean isDebuggerEnabled() {
        return ScriptDebugCache.isDebugEnabled();
    }

    public boolean isLoggerEnabled() {
        return ScriptDebugCache.isLogsEnabled();
    }

    public void info(DebuggableRuntime runtime, int line, Object value) {
        Map<String, Object> log = ScriptDebugCoordinator.getCommonLogInfo(runtime, line);
        String data = Throw.toMessage((Object)value);
        log.put("data", StringUtil.trim((String)data, (int)32000));
        ScriptDebugCache.pushLog(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBreakpoint(DebuggableRuntime runtime, int line, Set<Integer> breakpoints) {
        String id = UUID.randomUUID().toString();
        Map<String, Object> log = ScriptDebugCoordinator.buildBreakpointInfo(id, runtime, breakpoints, line);
        ScriptDebugCache.attachBreakpoint(log);
        try {
            ScriptDebugSignal.handle(runtime, id, line);
        }
        finally {
            ScriptDebugCache.removeBreakpoint(id);
        }
    }

    private static Map<String, Object> buildBreakpointInfo(String id, DebuggableRuntime runtime, Set<Integer> breakpoints, int line) {
        Map<String, Object> log = ScriptDebugCoordinator.getCommonLogInfo(runtime, line);
        log.put("id", id);
        log.put("lines", ScriptDebugCoordinator.getLines(runtime.getResource()));
        List<Map<String, Object>> list = ScriptDebugCoordinator.transform(breakpoints, line);
        log.put("breakpoints", list);
        return log;
    }

    static List<Map<String, Object>> transform(Collection<Integer> breakpoints, int line) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(breakpoints.size());
        for (Integer i : breakpoints) {
            HashMap<String, Constable> p = new HashMap<String, Constable>(4);
            p.put("line", i);
            p.put("is_current", Boolean.valueOf(line == i));
            list.add(p);
        }
        return list;
    }

    private static Map<String, Object> getCommonLogInfo(DebuggableRuntime runtime, int line) {
        DebuggableResource res = runtime.getResource();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HashMap<String, Object> log = new HashMap<String, Object>(8);
        log.put("time", df.format(new Timestamp(System.currentTimeMillis())));
        log.put("thread", Thread.currentThread().getName());
        log.put("line", line);
        log.put("script_short", res.getLine(line));
        String script = ScriptDebugCoordinator.getLines(res, line - 7, line + 7, line) + "\r\n\r\n\r\n// \u8282\u70b9\uff1a" + NetUtil.getServerId();
        log.put("script_long", script);
        log.put("program", ScriptDebugCoordinator.getId());
        return log;
    }

    public static String getId() {
        return Hash.md5((String)(Instance.getInstanceId() + "\r\n" + Thread.currentThread()));
    }

    private static List<String> getLines(DebuggableResource res) {
        int count = res.getLineCount();
        ArrayList<String> lines = new ArrayList<String>(count);
        for (int i = 1; i <= count; ++i) {
            lines.add(res.getLine(i));
        }
        return lines;
    }

    private static String getLines(DebuggableResource res, int from, int to, int current) {
        StringBuilder s = new StringBuilder();
        int i = Math.max(1, from);
        int j = Math.min(res.getLineCount(), to);
        if (i > 1) {
            s.append("...");
        }
        while (i <= j) {
            if (s.length() > 0) {
                s.append("\r\n");
            }
            if (i == current) {
                s.append(">> ");
            }
            s.append(res.getLine(i));
            ++i;
        }
        if (j > res.getLineCount()) {
            s.append("\r\n");
            s.append("...");
        }
        return s.toString();
    }
}

