/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.debug;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.debug.ScriptDebugCoordinator;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.feature.control.loop.Throw;

public class ScriptDebugSignal {
    public static final String COMMAND_SHUT_DOWN = "shut down";
    private static final ConcurrentHashMap<String, Breakpoint> breakpoints = new ConcurrentHashMap(64);

    public static void setBreakpoint(String breakpointId, int line, boolean flag) {
        if (!ScriptDebugSignal.mqSetBreakpoint(breakpointId, line, flag)) {
            BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugSignal.class.getName(), (String)"mqSetBreakpoint", (Object[])new Object[]{breakpointId, line});
        }
    }

    public static boolean mqSetBreakpoint(String breakpointId, int line, boolean flag) {
        Breakpoint item = breakpoints.get(breakpointId);
        if (item == null) {
            return false;
        }
        List breakpoints = item.setBreakpoint(line, flag);
        ScriptDebugCache.refreshBreakpoints(breakpointId, breakpoints);
        return true;
    }

    public static void resume(String breakpointId) {
        if (!ScriptDebugSignal.mqResume(breakpointId)) {
            BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugSignal.class.getName(), (String)"mqResume", (Object[])new Object[]{breakpointId});
        }
    }

    public static boolean mqResume(String breakpointId) {
        Breakpoint item = breakpoints.get(breakpointId);
        if (item == null) {
            return false;
        }
        item.resume();
        return true;
    }

    public static void setExpr(String breakpointId, String expr) {
        if (expr != null && expr.startsWith(COMMAND_SHUT_DOWN)) {
            expr = expr + ":" + RequestContext.get().getUserName();
        }
        if (!ScriptDebugSignal.mqSetExpr(breakpointId, expr)) {
            BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugSignal.class.getName(), (String)"mqSetExpr", (Object[])new Object[]{breakpointId, expr});
        }
    }

    public static boolean mqSetExpr(String breakpointId, String expr) {
        Breakpoint item = breakpoints.get(breakpointId);
        if (item == null) {
            return false;
        }
        item.setExpr(expr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handle(DebuggableRuntime runtime, String breakpointId, int line) {
        Breakpoint item = new Breakpoint(runtime, breakpointId, line);
        breakpoints.put(breakpointId, item);
        try {
            item.suspend();
        }
        finally {
            breakpoints.remove(breakpointId);
        }
    }

    public static final class Breakpoint {
        private volatile boolean finished = false;
        private volatile String expr;
        private final DebuggableRuntime runtime;
        private final String breakpointId;
        private final int line;

        public Breakpoint(DebuggableRuntime runtime, String breakpointId, int line) {
            this.runtime = runtime;
            this.breakpointId = breakpointId;
            this.line = line;
        }

        private synchronized List<Map<String, Object>> setBreakpoint(int line, boolean flag) {
            DebuggableResource p = this.runtime.getResource();
            if (flag) {
                p.attachBreakpoint(line);
            } else {
                p.detachBreakpoint(line);
            }
            return ScriptDebugCoordinator.transform(p.collectBreakpoints(), this.line);
        }

        private synchronized void suspend() {
            long start = System.currentTimeMillis();
            do {
                try {
                    this.wait(1000L);
                    Breakpoint.evalExpr(this);
                }
                catch (InterruptedException e) {
                    break;
                }
            } while (!this.finished && System.currentTimeMillis() - start <= 360000L);
        }

        private synchronized void setExpr(String expr) {
            this.expr = expr;
            this.notifyAll();
        }

        private synchronized void resume() {
            this.finished = true;
            this.notifyAll();
        }

        private static void evalExpr(Breakpoint item) {
            String expr = item.expr;
            item.expr = null;
            if (expr != null) {
                if (expr.startsWith(ScriptDebugSignal.COMMAND_SHUT_DOWN)) {
                    ScriptDebugCache.setExprResult(item.breakpointId, expr, ResManager.loadKDString((String)"\u5df2\u6839\u636e\u60a8\u7684\u6307\u4ee4\u5728\u811a\u672c\u6267\u884c\u73af\u5883\u4e2d\u89e6\u53d1\u4e86\u4e00\u4e2a\u4e2d\u65ad\u3002", (String)"ScriptDebugSignal_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                    String debugUser = expr.substring(ScriptDebugSignal.COMMAND_SHUT_DOWN.length() + 1);
                    String message = String.format(ResManager.loadKDString((String)"\u6839\u636e\u8c03\u8bd5\u8005\u201c%s\u201d\u7684\u547d\u4ee4\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"ScriptDebugSignal_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), debugUser);
                    throw new TaskCancelException(message);
                }
                String result = StringUtil.trim((String)Breakpoint.eval(item, expr), (int)30000);
                ScriptDebugCache.setExprResult(item.breakpointId, expr, result);
            }
        }

        private static String eval(Breakpoint item, String expr) {
            String data;
            try {
                Context ctx = item.runtime.getContext();
                Object result = Script.compileSimpleScript((String)expr).eval(ctx);
                data = Throw.toMessage((Object)result);
            }
            catch (Throwable e) {
                data = StringUtil.toString((Throwable)e);
            }
            return data;
        }
    }
}

