/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.util.misc.Triple;

public class EntityAndFieldsFilter {
    private static HashSet<String> ignoredRefSet = new HashSet();
    private static HashSet<Triple<String, String, String>> indirectRefSet = new HashSet();
    private static Map<String, String> replaceRefMap = new HashMap<String, String>();
    private static Map<String, Set<String>> ignoredRepeatEntityMap = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> retainMap = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> ignoredMap = new HashMap<String, Set<String>>();

    private static void addIndirectRef() {
        indirectRefSet.add((Triple<String, String, String>)new Triple((Object)"isc_metadata_schema", (Object)"prop_entryentity", (Object)"data_schema"));
    }

    private static void addIgnoredRef() {
        ignoredRefSet.add("isc_database_link");
        ignoredRefSet.add("isc_mq");
        ignoredRefSet.add("bos_entityobject");
        ignoredRefSet.add("bos_devportal_bizcloud");
        ignoredRefSet.add("bos_devportal_bizapp");
        ignoredRefSet.add("sch_job");
        ignoredRefSet.add("sch_schedule");
    }

    private static void addReplaceRef() {
        replaceRefMap.put("isc_system_query", "isc_system");
    }

    private static void addIgnoredRepeatEntity() {
        HashSet<String> connFields = new HashSet<String>();
        connFields.add("name");
        ignoredRepeatEntityMap.put("isc_sysconn", connFields);
        HashSet<String> serviceFields = new HashSet<String>();
        serviceFields.add("number");
        serviceFields.add("name");
        ignoredRepeatEntityMap.put("isc_system", serviceFields);
    }

    private static void addRetainFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("name");
        fields.add("group");
        fields.add("protocol");
        fields.add("connectableothersystem");
        fields.add("enable");
        fields.add("version");
        retainMap.put("isc_sysconn", fields);
        HashSet<String> mqServer = new HashSet<String>();
        mqServer.add("id");
        mqServer.add("masterid");
        mqServer.add("number");
        mqServer.add("name");
        mqServer.add("type");
        mqServer.add("server_port");
        mqServer.add("status");
        mqServer.add("enable");
        retainMap.put("isc_mq_server", mqServer);
    }

    private static void addIgnoredFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("multilanguagetext");
        fields.add("creater");
        fields.add("creater_id");
        fields.add("creator");
        fields.add("creator_id");
        fields.add("modifier");
        fields.add("modifier_id");
        fields.add("last_modifier");
        fields.add("last_modifier_id");
        fields.add("extendor");
        fields.add("extendor_id");
        fields.add("connection");
        fields.add("connection_id");
        fields.add("dblink");
        fields.add("dblink_id");
        fields.add("password");
        ignoredMap.put("*", fields);
        HashSet<String> meta = new HashSet<String>();
        meta.add("error_stack");
        meta.add("error_stack_tag");
        ignoredMap.put("isc_metadata_schema", meta);
        HashSet<String> cn_config = new HashSet<String>(2);
        cn_config.add("user");
        cn_config.add("newpwd");
        ignoredMap.put("isc_cn_config", cn_config);
        fields = new HashSet();
        fields.add("is_extended");
        fields.add("extensions");
        fields.add("extensions_tag");
        fields.add("extendor");
        fields.add("extendor_id");
        fields.add("extended_time");
        ignoredMap.put("iscx_resource", fields);
        fields = new HashSet(2);
        fields.add("mq_topic");
        fields.add("mq_topic_id");
        ignoredMap.put("iscx_data_flow_trigger", fields);
    }

    public static boolean isIgnoredField(String entityName, String field) {
        if (ignoredMap.get("*").contains(field)) {
            return true;
        }
        Set<String> ignoredFields = ignoredMap.get(entityName);
        if (ignoredFields != null && ignoredFields.contains(field)) {
            return true;
        }
        Set<String> set = retainMap.get(entityName);
        if (set != null) {
            return !set.contains(field);
        }
        return false;
    }

    public static boolean isRetainEntity(String entityName) {
        return retainMap.containsKey(entityName);
    }

    public static boolean isIgnoredRef(DynamicObject ref) {
        return ignoredRefSet.contains(ref.getDynamicObjectType().getName());
    }

    public static boolean isIndirectRef(String parent, String entity, String field) {
        return indirectRefSet.contains(new Triple((Object)parent.split(",")[0], (Object)entity, (Object)field));
    }

    public static Map<String, Set<String>> getRetainMap() {
        return retainMap;
    }

    public static Map<String, Set<String>> getIgnoredMap() {
        return ignoredMap;
    }

    public static Map<String, String> getReplaceRefMap() {
        return replaceRefMap;
    }

    public static boolean isReplaceRef(DynamicObject ref) {
        return replaceRefMap.containsKey(ref.getDynamicObjectType().getName());
    }

    public static Set<String> getIgnoredRefSet() {
        return (Set)ignoredRefSet.clone();
    }

    public static Set<Triple<String, String, String>> getIndirectRefSet() {
        return (Set)indirectRefSet.clone();
    }

    public static Map<String, Set<String>> getIgnoredRepeatEntityMap() {
        return ignoredRepeatEntityMap;
    }

    private void clearCollection() {
        ignoredRefSet.clear();
        indirectRefSet.clear();
    }

    static {
        EntityAndFieldsFilter.addIndirectRef();
        EntityAndFieldsFilter.addIgnoredRef();
        EntityAndFieldsFilter.addReplaceRef();
        EntityAndFieldsFilter.addIgnoredRepeatEntity();
        EntityAndFieldsFilter.addRetainFields();
        EntityAndFieldsFilter.addIgnoredFields();
    }
}

