/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.handler;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.handler.APISchemaAfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.AfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.DataCopySchemaAfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.DataCopyTriggerAfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.ServiceFlowAfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.export.ExportHandlerFactory;
import kd.isc.iscb.platform.core.dts.handler.iscx.DataFlowTriggerAfterSaveHandler;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class AfterSaveHandlerFactory {
    private static Map<String, AfterSaveHandler> factory = new HashMap<String, AfterSaveHandler>();

    private static void initHandlerByPropertiesFile() {
        InputStream in = ExportHandlerFactory.class.getClassLoader().getResourceAsStream("iscb/dts/import/import_after_save_handler.properties");
        try {
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                AfterSaveHandlerFactory.registerHandlers(properties);
            }
        }
        catch (Throwable e) {
            LogFactory.getLog(AfterSaveHandlerFactory.class).warn("init after save handlers error :", e);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private static void registerHandlers(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String className = D.s((Object)entry.getValue());
            if (className == null) continue;
            try {
                AfterSaveHandler handler = (AfterSaveHandler)ReflectionUtil.newInstance((String)className);
                factory.put(D.s((Object)entry.getKey()), handler);
            }
            catch (Throwable e) {
                LogFactory.getLog(AfterSaveHandlerFactory.class).warn("initialize after save handler class error \uff1a" + className, e);
            }
        }
    }

    public static AfterSaveHandler get(String key) {
        return factory.get(key);
    }

    static {
        factory.put("isc_data_copy", new DataCopySchemaAfterSaveHandler());
        factory.put("isc_data_copy_trigger", new DataCopyTriggerAfterSaveHandler());
        factory.put("isc_service_flow", new ServiceFlowAfterSaveHandler());
        factory.put("isc_call_api_by_evt", new APISchemaAfterSaveHandler());
        factory.put("iscx_data_flow_trigger", new DataFlowTriggerAfterSaveHandler());
        AfterSaveHandlerFactory.initHandlerByPropertiesFile();
    }
}

