/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.solution.resources.DeployResourceFromSolution;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.IscExportUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class IscExportTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(IscExportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u96c6\u6210\u8d44\u6e90\u5bfc\u51fa\u4efb\u52a1", (String)"IscExportTask_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), null);
        String operationKey = D.s((Object)params.get("operationKey"));
        DynamicObject[] objects = this.loadDynamicObjects(operationKey, params);
        String url = this.exportByOperation(operationKey, params, objects);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", url);
        this.feedbackCustomdata(result);
    }

    private DynamicObject[] loadDynamicObjects(String operationKey, Map<String, Object> params) {
        if ("exportSolutionResources".equals(operationKey)) {
            return null;
        }
        String entity = D.s((Object)params.get("entity"));
        List pkIds = (List)params.get("pkIds");
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        return objects;
    }

    private String exportByOperation(String operationKey, Map<String, Object> params, DynamicObject[] objects) {
        String url;
        if ("exportDts".equals(operationKey)) {
            url = this.exportDts(objects);
        } else if ("exportZip".equals(operationKey)) {
            url = this.exportZip(objects);
        } else if ("exportSolutionResources".equals(operationKey)) {
            url = this.exportSolutionResources(params);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u64cd\u4f5c\uff1a%s", (String)"IscExportTask_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), operationKey));
        }
        return url;
    }

    private String exportDts(DynamicObject[] objects) {
        String tempFilePath = FileUtil.getLocalPath(ExportAndImportFormUtil.generateFileName(objects));
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFilePath), 524288);){
            this.export(out, objects, true);
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fadts\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"IscExportTask_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        String url = this.download(tempFilePath);
        return url;
    }

    private String download(String tempFilePath) {
        String string;
        BufferedInputStream in = null;
        try {
            String url;
            in = new BufferedInputStream(new FileInputStream(tempFilePath), 524288);
            string = url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(tempFilePath.substring(tempFilePath.lastIndexOf(File.separator) + 1), (InputStream)in, 1800);
            this.close(in);
        }
        catch (Exception e) {
            try {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fadts\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"IscExportTask_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(in);
                FileUtil.delete(tempFilePath);
                throw throwable;
            }
        }
        FileUtil.delete(tempFilePath);
        return string;
    }

    private void close(BufferedInputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("\u5bfc\u51fadts\uff0c\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            }
        }
    }

    public void export(OutputStream out, DynamicObject[] objects, boolean exportDependencies) throws IOException {
        List<DynamicObject> list = exportDependencies ? this.loadObjectsAndDependencies(objects) : Arrays.asList(objects);
        int size = list.size();
        int writtenBytes = 0;
        int maxBytesSize = 0x400000;
        for (int i = 0; i < size; ++i) {
            this.isStopByUser();
            int progress = 80 + 20 * (i + 1) / size;
            this.refreshExportDtsProgress(progress);
            DynamicObject o = list.get(i);
            Map<String, Object> map = ExportDynamicObject.object2map(o);
            map.put("$id", o.getPkValue());
            map.put("$entityname", o.getDataEntityType().getName());
            map.put("$isref", !ExportDynamicObject.exists(o, objects));
            String s = Json.toString(map);
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            if (writtenBytes + bytes.length > maxBytesSize) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u8fc7\u5355\u4e2a\u6587\u4ef6\u5bfc\u51fa\u7684\u6700\u5927\u503c4M\uff0c\u8bf7\u51cf\u5c11\u5bfc\u51fa\u8d44\u6e90\u6570\u91cf\u6216\u8005\u66ff\u6362\u6210\u5bfc\u51fazip\u5305", (String)"IscExportTask_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]));
            }
            writtenBytes += bytes.length;
            out.write(bytes);
            out.write(10);
        }
    }

    /*
     * Exception decompiling
     */
    public String exportZip(DynamicObject[] objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeZipContent(DynamicObject[] objects, ZipOutputStream zipOutputStream) throws IOException {
        int total = objects.length;
        for (int i = 0; i < total; ++i) {
            this.isStopByUser();
            this.refreshProgress(i, total);
            DynamicObject dObj = objects[i];
            String dtsFileName = IscExportUtil.generateDtsName(new DynamicObject[]{dObj}, i + 1) + ".dts";
            zipOutputStream.putNextEntry(new ZipEntry(dtsFileName));
            ExportDynamicObject.export((OutputStream)zipOutputStream, dObj);
            zipOutputStream.closeEntry();
        }
    }

    private void refreshExportDtsProgress(int progress) {
        String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790\u4f9d\u8d56\u8d44\u6e90\u5e76\u5bfc\u51fa", (String)"IscExportTask_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]);
        this.feedbackProgress(progress, desc, null);
    }

    private void refreshProgress(int i, int total) {
        int progress = 100 * i / total;
        String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c %1$s / %2$s \u4e2a\u8d44\u6e90", (String)"IscExportTask_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), i + 1, total);
        this.feedbackProgress(progress, desc, null);
    }

    public List<DynamicObject> loadObjectsAndDependencies(DynamicObject[] objects) {
        Graph g = new Graph();
        int len = objects.length;
        for (int i = 0; i < len; ++i) {
            this.isStopByUser();
            int progress = 80 * (i + 1) / len;
            this.refreshExportDtsProgress(progress);
            DynamicObject o = objects[i];
            ExportDynamicObject.append((Graph<DynamicObject>)g, o);
        }
        List list = g.topSort();
        if (list.size() != g.getNodeCount()) {
            Map<String, List<String>> bills = ExportDynamicObject.getCrossRefs((Graph<DynamicObject>)g, list);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff01\u6d89\u53ca\u7684\u5355\u636e\u6709\uff1a%s", (String)"IscExportTask_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), bills));
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public String exportSolutionResources(Map<String, Object> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeResourcesContent(List<Object> entryIds, DeployResourceFromSolution deploys, ZipOutputStream zipOutputStream) throws IOException {
        int total = entryIds.size();
        for (int i = 0; i < entryIds.size(); ++i) {
            this.isStopByUser();
            this.refreshProgress(i, total);
            long entryId = D.l((Object)entryIds.get(i));
            List<DynamicObject> refEntry = deploys.loadDependencies(entryId);
            DynamicObject mainEntry = deploys.loadMain(entryId);
            String dtsFileName = IscExportUtil.generateFileName(mainEntry) + ".dts";
            ZipEntry zipEntry = new ZipEntry(dtsFileName);
            zipOutputStream.putNextEntry(zipEntry);
            IscExportUtil.writeContent(zipOutputStream, refEntry, mainEntry);
        }
    }

    private void isStopByUser() {
        if (this.isStop()) {
            this.stop();
        }
    }

    private String generateZipFileName(DynamicObjectType entityType) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String date = df.format(new Date());
        return entityType.getDisplayName().getLocaleValue() + date;
    }

    private String generateZipFileName(Map<String, Object> params) {
        String entity = D.s((Object)params.get("entity"));
        String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString();
        String solutionName = D.s((Object)params.get("solutionName"));
        String solutionNumber = D.s((Object)params.get("solutionNumber"));
        String sessionId = Hash.mur16((Object[])new Object[]{RequestContext.get().getGlobalSessionId()});
        String version = D.s((Object)params.get("version"));
        String fileName = entityName + '_' + solutionName + '(' + solutionNumber + ")_" + version + '_' + sessionId;
        fileName = fileName.replace('(', '\uff08');
        fileName = fileName.replace(')', '\uff09');
        return fileName;
    }
}

