/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.env;

import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.Script;

public class VariableCache
implements ObjectSizeIgnored {
    private String number;
    private Object val;
    private DynamicObject var;
    private final boolean isArray;
    private DataType dataType;
    private Script script;

    public VariableCache(DynamicObject var) {
        this.var = var;
        this.number = var.getString("number");
        this.isArray = var.getBoolean("is_array");
        String rawValue = var.getString("value");
        this.parseDataType();
        this.parseRawValue(rawValue);
    }

    private void parseDataType() {
        String type = D.s((Object)this.var.getDynamicObject("type").get("number"));
        this.dataType = DataTypes.get((String)type);
        if (this.isArray) {
            this.dataType = DataTypes.listType((DataType)this.dataType);
        }
    }

    private boolean isScript(String rawValue) {
        String tmp = D.s((Object)rawValue);
        if (tmp == null) {
            return false;
        }
        return rawValue.startsWith("<%") && rawValue.endsWith("%>");
    }

    private void parseRawValue(String rawValue) {
        if (this.isScript(rawValue)) {
            this.script = Script.compile((String)rawValue.substring(2, rawValue.lastIndexOf("%>")));
        } else if (this.isArray) {
            Object json = Script.parseJson((String)rawValue);
            this.val = this.dataType.narrow(json);
        } else {
            this.val = this.dataType.narrow((Object)rawValue);
        }
    }

    public Object getValue() {
        if (this.script == null) {
            return this.val;
        }
        return this.dataType.narrow(this.script.eval());
    }

    public static VariableCache getByNumber(String number) {
        return CacheableObjectManager.getByNumber(VariableCache.class, number);
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Object getVal() {
        return this.val;
    }

    public void setVal(Object val) {
        this.val = val;
    }

    public DynamicObject getVar() {
        return this.var;
    }

    public void setVar(DynamicObject var) {
        this.var = var;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<VariableCache>(){

            @Override
            public String entityType() {
                return "isc_env_variable";
            }

            @Override
            public VariableCache create(DynamicObject var) {
                return new VariableCache(var);
            }

            @Override
            public Class<VariableCache> target() {
                return VariableCache.class;
            }
        });
    }
}

