/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.factory;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ExtensibleConnectionFactory;
import kd.isc.iscb.platform.core.connector.db_proxy.DatabaseProxyConnectionFactory;
import kd.isc.iscb.platform.core.connector.dummy.DummyConnectionFactory;
import kd.isc.iscb.platform.core.connector.eas.EasProxyConnectionFactory;
import kd.isc.iscb.platform.core.connector.ierp.IERPConnectionFactory;
import kd.isc.iscb.platform.core.connector.ischub.IscHubConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.DmConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.MySqlConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.OracleConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.PgSqlConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.SqlServerConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.newpgsql.NewPgSqlConnectionFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyConnectFactory;
import kd.isc.iscb.platform.core.connector.olap.OlapConnectionFactory;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.platform.core.connector.webapi.SessionCache;
import kd.isc.iscb.platform.core.connector.webapi.SupportWebhookEvent;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.dc.mq.factory.ExternalKafkaFactory;
import kd.isc.iscb.platform.core.dc.mq.factory.ExternalMqsFactory;
import kd.isc.iscb.platform.core.dc.mq.factory.ExternalRabbitFactory;
import kd.isc.iscb.platform.core.dc.mq.factory.ExternalRocketFactory;
import kd.isc.iscb.platform.core.dc.mq.factory.InternalRabbitFactory;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.ReflectionUtil;

public final class FactoryManager {
    private static Log logger = LogFactory.getLog(FactoryManager.class);
    private static final ReadLockFreeMap<String, Map<String, Item>> factories = new ReadLockFreeMap();
    private static final int INIT_FACTORY_SIZE = 24;

    public static Object get(String type) {
        Item item = FactoryManager.getItem(type);
        Object factory = item.getFactory();
        if (factory instanceof Throwable) {
            throw D.e((Throwable)((Throwable)factory));
        }
        return factory;
    }

    public static Object find(String type) {
        String account = RequestContext.get().getAccountId();
        return FactoryManager.find(type, account);
    }

    public static Object find(String type, String account) {
        Item item = FactoryManager.findItem(type, account);
        if (item == null) {
            return null;
        }
        Object factory = item.getFactory();
        if (factory instanceof Throwable) {
            return null;
        }
        return factory;
    }

    public static String getForm(String type) {
        Item item = FactoryManager.getItem(type);
        String form = item.formId;
        if (form == null) {
            boolean isMQ = FactoryManager.get(type) instanceof MessageQueueServerFactory;
            form = isMQ ? "isc_mq_server" : "isc_database_link";
        }
        return form;
    }

    public static String getName(String type) {
        Item item = FactoryManager.findItem(type);
        return item != null ? item.name : ResManager.loadKDString((String)"\u672a\u6ce8\u518c", (String)"FactoryManager_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static void resetEnvironment() {
        String account = RequestContext.get().getAccountId();
        FactoryManager.initFactories(account, true);
    }

    public static void resetEnvironmentForMQ(String tenant, String account) {
        RequestContext ctx = ContextUtil.createRequestContext(account, tenant);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        FactoryManager.initFactories(account, false);
    }

    private static Item getItem(String type) {
        Item item = FactoryManager.findItem(type);
        if (item != null) {
            return item;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\uff08%s\uff09\u672a\u6ce8\u518c\uff01,\u8bf7\u524d\u5f80\u96c6\u6210\u7ba1\u7406-\u8fde\u63a5\u7ba1\u7406-\u8fde\u63a5\u7c7b\u578b\u7684\u67e5\u770b\u9875\u9762\u70b9\u51fb\u5237\u65b0\u73af\u5883\u6309\u94ae\u5237\u65b0\u3002", (String)"FactoryManager_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    private static Item findItem(String type) {
        String account = RequestContext.get().getAccountId();
        return FactoryManager.findItem(type, account);
    }

    private static Item findItem(String type, String account) {
        Map items = (Map)factories.get((Object)account);
        if (items == null) {
            FactoryManager.initFactories(account, false);
            items = (Map)factories.get((Object)account);
        }
        Item item = (Item)items.get(type);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFactories(String account, boolean throwsError) {
        Map<String, Item> items;
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            if (!current.getAccountId().equals(account)) {
                new_rc = ContextUtil.createRequestContext(account, current.getTenantId());
                RequestContextCreator.restoreForMQ((RequestContext)new_rc);
            }
            items = FactoryManager.retrieveFactoryItem(throwsError);
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
        FactoryManager.setDefaultFactories(items);
        factories.put((Object)account, items);
        SessionCache.clearCache();
    }

    private static Map<String, Item> retrieveFactoryItem(boolean throwsError) {
        Map<String, Item> items;
        try {
            items = FactoryManager.loadCfgFromDB();
        }
        catch (Throwable e) {
            if (throwsError) {
                throw e;
            }
            logger.warn("isc-factory-manager-init-failed", e);
            items = new HashMap<String, Item>();
        }
        return items;
    }

    private static void setDefaultFactories(Map<String, Item> items) {
        for (Map.Entry<String, String> i : FactoryManager.getDefaultFactories().entrySet()) {
            String type = i.getKey();
            if (items.containsKey(type)) continue;
            Item item = new Item();
            item.type = type;
            item.factoryClass = i.getValue();
            item.formId = null;
            items.put(item.type, item);
        }
    }

    private static Map<String, Item> loadCfgFromDB() {
        List<DataRow> list = FactoryManager.loadTypes();
        HashMap<String, Item> items = new HashMap<String, Item>(list.size());
        for (DataRow i : list) {
            Item item = FactoryManager.newItem(i);
            items.put(item.type, item);
        }
        return items;
    }

    private static List<DataRow> loadTypes() {
        String sql = "SELECT M.fid as id, M.fnumber as number, L.fname as name,  M.ffactory_class as factory_class,M.fconfig_form as config_form, M.flogin_script as login_script,M.flogin_script_tag as login_script_tag,  M.ftest_script as test_script,M.ftest_script_tag as test_script_tag,  M.frefresh_script as refresh_script,M.frefresh_script_tag as refresh_script_tag,  M.finvoke_script as invoke_script,M.finvoke_script_tag  as invoke_script_tag,  M.fscript_extension as script_extension,  M.freg_event_script as reg_script,M.freg_event_script_tag as reg_script_tag,  M.funreg_event_script as unreg_script,M.funreg_event_script_tag as unreg_script_tag,  M.fevent_handle_script as evt_handle_script,M.fevent_handle_script_tag as evt_handle_script_tag FROM t_iscb_connection_type M left join t_iscb_connection_type_l L on L.fid=M.fid and L.flocaleid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(D.s((Object)RequestContext.get().getLang())), Collections.singletonList(12));
            return list;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private static Item newItem(DataRow cfg) {
        Item item = new Item();
        item.type = D.s((Object)cfg.get((Object)"number"));
        item.factoryClass = D.s((Object)cfg.get((Object)"factory_class"));
        item.formId = D.s((Object)cfg.get((Object)"config_form"));
        item.name = D.s((Object)cfg.get((Object)"name"));
        FactoryManager.setLoginScript(cfg, item);
        FactoryManager.setInvokeScript(cfg, item);
        FactoryManager.setTestScript(cfg, item);
        FactoryManager.setRefreshScript(cfg, item);
        FactoryManager.setExtensions(cfg, item);
        FactoryManager.setRegEventScript(cfg, item);
        FactoryManager.setUnRegEventScript(cfg, item);
        FactoryManager.setEventHandleScript(cfg, item);
        return item;
    }

    private static void setExtensions(DataRow i, Item item) {
        item.script_extension = D.s((Object)i.get((Object)"script_extension"));
    }

    private static void setTestScript(DataRow i, Item item) {
        item.testScript = D.s((Object)i.get((Object)"test_script_tag"));
        if (item.testScript == null) {
            item.testScript = D.s((Object)i.get((Object)"test_script"));
        }
    }

    private static void setRefreshScript(DataRow i, Item item) {
        item.refreshScript = D.s((Object)i.get((Object)"refresh_script_tag"));
        if (item.refreshScript == null) {
            item.refreshScript = D.s((Object)i.get((Object)"refresh_script"));
        }
    }

    private static void setInvokeScript(DataRow i, Item item) {
        item.invokeScript = D.s((Object)i.get((Object)"invoke_script_tag"));
        if (item.invokeScript == null) {
            item.invokeScript = D.s((Object)i.get((Object)"invoke_script"));
        }
    }

    private static void setLoginScript(DataRow i, Item item) {
        item.loginScript = D.s((Object)i.get((Object)"login_script_tag"));
        if (item.loginScript == null) {
            item.loginScript = D.s((Object)i.get((Object)"login_script"));
        }
    }

    private static void setRegEventScript(DataRow i, Item item) {
        item.registerWebhookEventScript = D.s((Object)i.get((Object)"reg_script_tag"));
        if (item.registerWebhookEventScript == null) {
            item.registerWebhookEventScript = D.s((Object)i.get((Object)"reg_script"));
        }
    }

    private static void setUnRegEventScript(DataRow i, Item item) {
        item.unregisterWebhookEventScript = D.s((Object)i.get((Object)"unreg_script_tag"));
        if (item.unregisterWebhookEventScript == null) {
            item.unregisterWebhookEventScript = D.s((Object)i.get((Object)"unreg_script"));
        }
    }

    private static void setEventHandleScript(DataRow i, Item item) {
        item.webhookMsgHandleScript = D.s((Object)i.get((Object)"evt_handle_script_tag"));
        if (item.webhookMsgHandleScript == null) {
            item.webhookMsgHandleScript = D.s((Object)i.get((Object)"evt_handle_script"));
        }
    }

    private static Map<String, String> getDefaultFactories() {
        HashMap<String, String> map = new HashMap<String, String>(24);
        map.put("oracle", OracleConnectionFactory.class.getName());
        map.put("sqlserver", SqlServerConnectionFactory.class.getName());
        map.put("mysql", MySqlConnectionFactory.class.getName());
        map.put("PostgreSQL", PgSqlConnectionFactory.class.getName());
        map.put("PostgreSQL_New", NewPgSqlConnectionFactory.class.getName());
        map.put("Dm", DmConnectionFactory.class.getName());
        map.put("KD_OLAP", OlapConnectionFactory.class.getName());
        map.put("self", SelfConnectionFactory.class.getName());
        map.put("eas", EasProxyConnectionFactory.class.getName());
        map.put("db_proxy", DatabaseProxyConnectionFactory.class.getName());
        map.put("k3cloud", K3CloudProxyConnectFactory.class.getName());
        map.put("ierp", IERPConnectionFactory.class.getName());
        map.put("isc_hub", IscHubConnectionFactory.class.getName());
        map.put("DummyConnector", DummyConnectionFactory.class.getName());
        map.put("ExternalKafka", ExternalKafkaFactory.class.getName());
        map.put("ExternalRabbit", ExternalRabbitFactory.class.getName());
        map.put("InternalRabbit", InternalRabbitFactory.class.getName());
        map.put("ExternalRocket", ExternalRocketFactory.class.getName());
        map.put("ExternalMqs", ExternalMqsFactory.class.getName());
        map.put("ExternalActive", "kd.isc.activemq.ExternalActiveMqFactory");
        map.put("ExternalMsmq", "kd.isc.msmq.ExternalMsmqFactory");
        return map;
    }

    public static class Item {
        private String type;
        private String factoryClass;
        private String formId;
        private String name;
        private String loginScript;
        private String invokeScript;
        private String testScript;
        private String refreshScript;
        private String script_extension;
        private volatile Object factory;
        private String registerWebhookEventScript;
        private String unregisterWebhookEventScript;
        private String webhookMsgHandleScript;

        public Object getFactory() {
            Object factory = this.factory;
            if (factory == null) {
                this.createFactory();
                factory = this.factory;
            }
            return factory;
        }

        private void createFactory() {
            try {
                Object factory = ReflectionUtil.newInstance((String)this.factoryClass);
                if (factory instanceof ExtensibleConnectionFactory) {
                    ExtensibleConnectionFactory efactory = (ExtensibleConnectionFactory)factory;
                    efactory.bindScript(this.loginScript, this.refreshScript, this.invokeScript, this.testScript, this.script_extension);
                    if (factory instanceof SupportWebhookEvent) {
                        SupportWebhookEvent supportWebhookEventFac = (SupportWebhookEvent)factory;
                        supportWebhookEventFac.bindWebhookEventScript(this.registerWebhookEventScript, this.unregisterWebhookEventScript, this.webhookMsgHandleScript);
                    }
                }
                this.factory = factory;
            }
            catch (Throwable e) {
                this.factory = e;
            }
        }

        public Item() {
        }

        public Item(String type, String factoryClass, String formId, String script_extension) {
            this.type = type;
            this.factoryClass = factoryClass;
            this.formId = formId;
            this.script_extension = script_extension;
        }
    }
}

