/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.fn.ScriptFunction;
import kd.isc.iscb.platform.core.fn.ScriptFunctionFactory;
import kd.isc.iscb.platform.core.fn.ScriptFunctionProxy;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.Reference;

public class ScriptFunctionManager {
    public static ScriptFunctionProxy getProxy(Long id) {
        return new ScriptFunctionProxy(id);
    }

    public static ScriptFunction getFunction(Long id) {
        return CacheableObjectManager.get(ScriptFunction.class, id);
    }

    public static boolean cacheContains(long id) {
        return CacheableObjectManager.cacheContains(ScriptFunction.class, id);
    }

    static ScriptFunction compile(DynamicObject cfg) {
        List<Pair<String, DataType>> inputs = ScriptFunctionManager.getInputs(cfg);
        List<Pair<String, DataType>> outputs = ScriptFunctionManager.getOuputs(cfg);
        Script script = ScriptFunctionManager.compileScript(cfg, inputs, outputs);
        String number = D.s((Object)cfg.getString("number"));
        return new ScriptFunction(number, script, inputs, outputs);
    }

    private static Script compileScript(DynamicObject obj, List<Pair<String, DataType>> inputs, List<Pair<String, DataType>> outputs) {
        HashMap<Object, Reference> ctx = new HashMap<Object, Reference>(inputs.size() + outputs.size());
        for (Pair<String, DataType> p : outputs) {
            ctx.put(p.getKey(), Reference.create((String)((String)p.getKey())));
        }
        for (Pair<String, DataType> p : inputs) {
            ctx.put(p.getKey(), Reference.create((String)((String)p.getKey())));
        }
        Script script = Script.compile((String)obj.getString("script_jst_tag"), ctx);
        return script;
    }

    private static List<Pair<String, DataType>> getOuputs(DynamicObject obj) {
        DynamicObjectCollection items = obj.getDynamicObjectCollection("result_entries");
        ArrayList<Pair<String, DataType>> outputs = new ArrayList<Pair<String, DataType>>(items.size());
        for (DynamicObject item : items) {
            String name = D.s((Object)item.getString("result_name"));
            DataType type = DataTypes.get((String)D.s((Object)item.getString("result_type")));
            outputs.add((Pair<String, DataType>)new Pair((Object)name, (Object)type));
        }
        return outputs;
    }

    private static List<Pair<String, DataType>> getInputs(DynamicObject obj) {
        DynamicObjectCollection items = obj.getDynamicObjectCollection("function_entries");
        ArrayList<Pair<String, DataType>> inputs = new ArrayList<Pair<String, DataType>>(items.size());
        for (DynamicObject item : items) {
            String name = D.s((Object)item.getString("function_name"));
            DataType type = DataTypes.get((String)D.s((Object)item.getString("function_type")));
            inputs.add((Pair<String, DataType>)new Pair((Object)name, (Object)type));
        }
        return inputs;
    }

    static {
        CacheableObjectManager.registerFactory(new ScriptFunctionFactory());
        Functions.init();
    }
}

