/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn.ext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.mem.MemoryControl;
import kd.isc.iscb.util.misc.mem.MemoryUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public final class DefaultMemoryControl
implements MemoryControl {
    private static final ConcurrentHashMap<String, Boolean> cache = new ConcurrentHashMap();

    public boolean isEnabled() {
        String tenant = RequestContext.get().getTenantId();
        Boolean enabled = cache.get(tenant);
        if (enabled == null) {
            String s = System.getProperty("ISC_MEM_CTRL_ENABLED");
            enabled = s != null ? Boolean.valueOf(D.x((Object)s)) : Boolean.valueOf(!SystemContext.isProcEnv());
            cache.putIfAbsent(tenant, enabled);
        }
        return enabled;
    }

    static {
        ScheduleManager.submit((Task)new DaemonTask(){

            @Override
            public String getId() {
                return this.getClass().getName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                        String key = D.s((Object)e.getKey());
                        String value = D.s((Object)e.getValue());
                        if (key == null || value == null || !key.endsWith("_ISC_MEM_CTRL_ENABLED")) continue;
                        String tenant = key.substring(0, key.length() - "_ISC_MEM_CTRL_ENABLED".length());
                        boolean enabled = D.x((Object)value);
                        cache.put(tenant, enabled);
                    }
                }
                finally {
                    ScheduleManager.submit((Task)this, 10);
                }
            }
        }, 1);
        ScheduleManager.submit((Task)new DaemonTask(){

            @Override
            public void run() {
                try {
                    MemoryUtil.refreshState();
                }
                finally {
                    ScheduleManager.submit((Task)this, 0);
                }
            }

            @Override
            public String getId() {
                return this.getClass().getName();
            }
        }, ContextUtil.createRequestContext("FAKE_TENANT", "100000101", "0", "fake"), 1);
    }
}

