/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn.ext;

import java.beans.PropertyChangeSupport;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ftp.script.FtpToolKit;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.BusinessEventInvoke;
import kd.isc.iscb.platform.core.dc.IscScriptLogger;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.ThisURL;
import kd.isc.iscb.platform.core.dc.f.script.DataFileToolKit;
import kd.isc.iscb.platform.core.dc.f.script.a.ReadCSVFnc;
import kd.isc.iscb.platform.core.dc.f.script.a.ReadXLSXFnc;
import kd.isc.iscb.platform.core.dc.f.script.a.WriteCSVFnc;
import kd.isc.iscb.platform.core.dc.f.script.a.WriteXLSXFnc;
import kd.isc.iscb.platform.core.dc.f.script.attachment.field.AttachFieldServiceToolkit;
import kd.isc.iscb.platform.core.dc.f.script.attachment.panel.AttachPanelServiceToolkit;
import kd.isc.iscb.platform.core.debug.ScriptDebugCoordinator;
import kd.isc.iscb.platform.core.env.EnvironmentVariable;
import kd.isc.iscb.platform.core.fn.ext.CheckCancelSignal;
import kd.isc.iscb.platform.core.fn.ext.ConvertToUrlEncodeString;
import kd.isc.iscb.platform.core.fn.ext.DefaultMemoryControl;
import kd.isc.iscb.platform.core.fn.ext.DynamicObjectPropertyAccessor;
import kd.isc.iscb.platform.core.fn.ext.FastJsonFormat;
import kd.isc.iscb.platform.core.fn.ext.FastJsonParse;
import kd.isc.iscb.platform.core.fn.ext.GetContext;
import kd.isc.iscb.platform.core.fn.ext.GetCosmicIDRangeByDate;
import kd.isc.iscb.platform.core.fn.ext.GetCreateTimeByCosmicId;
import kd.isc.iscb.platform.core.fn.ext.MapToURLEncodeString;
import kd.isc.iscb.platform.core.fn.ext.NewBOID;
import kd.isc.iscb.platform.core.fn.ext.NewIntegerId;
import kd.isc.iscb.platform.core.fn.ext.NewUUID;
import kd.isc.iscb.platform.core.fn.ext.OpenApiRequestPropertyAccessor;
import kd.isc.iscb.platform.core.fn.ext.ParseCron;
import kd.isc.iscb.platform.core.fn.ext.ParseJsoup;
import kd.isc.iscb.platform.core.fn.ext.RSA_Decrypt;
import kd.isc.iscb.platform.core.fn.ext.RSA_Encrypt;
import kd.isc.iscb.platform.core.fn.ext.SM4Decrypt;
import kd.isc.iscb.platform.core.fn.ext.SM4Encrypt;
import kd.isc.iscb.platform.core.fn.ext.WebApiContextPropertyAccessor;
import kd.isc.iscb.platform.core.fn.ext.WithContext;
import kd.isc.iscb.platform.core.fn.ext.apachehttp.ApacheHttpPatch;
import kd.isc.iscb.platform.core.fn.ext.http.HttpToolKit;
import kd.isc.iscb.platform.core.fn.json.ApiResultSerializer;
import kd.isc.iscb.platform.core.fn.json.DynamicObjectSerializer;
import kd.isc.iscb.platform.core.fn.json.OperationResultSerializer;
import kd.isc.iscb.platform.core.fn.wf.GetWorkflowState;
import kd.isc.iscb.platform.core.fn.wf.InitiateWorkflow;
import kd.isc.iscb.platform.core.fn.wf.QueryWorkflowState;
import kd.isc.iscb.platform.core.sf.runtime.ServiceFlowProcess;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.ErrorSerializer;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.LockFactory;
import kd.isc.iscb.util.misc.mem.ClassFilter;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.script.CancelSignal;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.PropertyAccessor;
import kd.isc.iscb.util.script.misc.log.Logger;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class Functions {
    public static void init() {
    }

    private static void initMemoryControl() {
        DefaultMemoryControl.REF.set((Object)new DefaultMemoryControl());
        ObjectSizeCalculator.registerFilter((ClassFilter)new ClassFilter(){

            public boolean isIgnored(Class<?> clazz) {
                return DynamicObjectType.class.isAssignableFrom(clazz) || PropertyChangeSupport.class.isAssignableFrom(clazz) || DataEntityPropertyCollection.class.isAssignableFrom(clazz);
            }
        });
    }

    private static CancelSignal newCancelSignal() {
        return new CancelSignal(){

            public void check() throws TaskCancelException {
                SignalManager.checkCancelSignal();
            }
        };
    }

    private static ErrorSerializer newErrorSerializer() {
        return new ErrorSerializer(){

            public String toString(Throwable e) {
                return ShowStackTraceUtil.getErrorMsg(e);
            }
        };
    }

    private static void registerJsonSerializers() {
        Json.register((Json.Serializer)new ApiResultSerializer());
        Json.register((Json.Serializer)new DynamicObjectSerializer());
        Json.register((Json.Serializer)new OperationResultSerializer());
    }

    private static void registerPropertyAccessors() {
        LifeScriptEngine.register((PropertyAccessor)new DynamicObjectPropertyAccessor());
        LifeScriptEngine.register((PropertyAccessor)new WebApiContextPropertyAccessor());
        LifeScriptEngine.register((PropertyAccessor)new OpenApiRequestPropertyAccessor());
    }

    private static void initScriptLogger() {
        LoggerFactory.REF.set((Object)new LoggerFactory(){

            public Logger getLogger(String name) {
                return new IscScriptLogger();
            }

            public Logger getLogger(Class<?> cls) {
                return new IscScriptLogger();
            }
        });
    }

    private static void initScriptLockFactory() {
        LockFactory.INSTANCE.set((Object)new LockFactory(){

            public LockFactory.Lock getLock(String key) {
                final DLock lock = DLock.create((String)("/isc/script/sync/" + key)).fastMode();
                return new LockFactory.Lock(){

                    public boolean tryLock(int timeout) {
                        return lock.tryLock((long)timeout);
                    }

                    public void unLock() {
                        lock.unlock();
                    }

                    public void close() {
                        lock.close();
                    }
                };
            }
        });
    }

    private static void registerFunctions() {
        Script.register((Identifier)new NewIntegerId());
        Script.register((Identifier)new CheckCancelSignal());
        Script.register((Identifier)new NewUUID());
        Script.register((Identifier)new NewBOID());
        Script.register((Identifier)new ThisURL());
        Script.register((Identifier)new GetContext());
        Script.registerSimpleEngine((Identifier)new GetContext());
        Script.register((Identifier)new WithContext());
        Script.register((Identifier)ServiceFlowProcess.SERVICE_FLOW_PROCESS);
        Script.registerSimpleEngine((Identifier)ServiceFlowProcess.SERVICE_FLOW_PROCESS);
        Script.register((Identifier)new FtpToolKit());
        Script.register((Identifier)new InitiateWorkflow());
        Script.register((Identifier)new QueryWorkflowState());
        Script.register((Identifier)new GetWorkflowState());
        Script.register((Identifier)new FastJsonFormat());
        Script.register((Identifier)new FastJsonParse());
        Script.register((Identifier)new DataFileToolKit());
        Script.register((Identifier)new AttachPanelServiceToolkit());
        Script.register((Identifier)new AttachFieldServiceToolkit());
        Script.register((Identifier)new FlatObjectToMapOrList());
        Script.register((Identifier)new ReadXLSXFnc());
        Script.register((Identifier)new WriteXLSXFnc());
        Script.register((Identifier)new ReadCSVFnc());
        Script.register((Identifier)new WriteCSVFnc());
        Script.register((Identifier)new RSA_Decrypt());
        Script.register((Identifier)new RSA_Encrypt());
        Script.register((Identifier)new SM4Decrypt());
        Script.register((Identifier)new SM4Encrypt());
        Script.register((String)"ISC_ENV", (Object)new EnvironmentVariable());
        Script.register((Identifier)new GetCreateTimeByCosmicId());
        Script.register((Identifier)new GetCosmicIDRangeByDate());
        Script.register((Identifier)new ParseJsoup());
        Script.register((Identifier)new ParseCron());
        Script.register((Identifier)new MapToURLEncodeString());
        Script.register((Identifier)new ConvertToUrlEncodeString());
        Script.register((Identifier)new BusinessEventInvoke());
        Script.register((Identifier)new ApacheHttpPatch());
        Script.register((Identifier)new HttpToolKit());
    }

    static {
        try {
            DebugCoordinator.REF.set((Object)new ScriptDebugCoordinator());
            Functions.initScriptLogger();
            Functions.initScriptLockFactory();
            Functions.registerJsonSerializers();
            Functions.registerPropertyAccessors();
            Functions.registerFunctions();
            ErrorSerializer.REF.set((Object)Functions.newErrorSerializer());
            CancelSignal.REF.set((Object)Functions.newCancelSignal());
            Functions.initMemoryControl();
        }
        catch (Throwable e) {
            Log logger = LogFactory.getLog(Functions.class);
            logger.error("Functions_init_failed.", e);
            throw e;
        }
    }
}

