/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn.ext.apachehttp;

import java.io.IOException;
import java.util.Map;
import kd.isc.iscb.platform.core.fn.ext.apachehttp.WrapResponse;
import kd.isc.iscb.util.dt.D;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheHttpUtil {
    private static volatile CloseableHttpClient CLIENT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getClient() {
        if (CLIENT != null) return CLIENT;
        Class<ApacheHttpUtil> clazz = ApacheHttpUtil.class;
        synchronized (ApacheHttpUtil.class) {
            if (CLIENT != null) return CLIENT;
            CLIENT = ApacheHttpUtil.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CLIENT;
        }
    }

    public static Map<String, Object> httpPatch(String url, String data, String charset, Map<String, Object> headers) {
        HttpPatch httpPatch = new HttpPatch(url);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            httpPatch.setHeader(entry.getKey(), D.s((Object)entry.getValue()));
        }
        httpPatch.setEntity((HttpEntity)new StringEntity(data, charset));
        try {
            return (Map)ApacheHttpUtil.getClient().execute((HttpUriRequest)httpPatch, (ResponseHandler)new WrapResponse(url));
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    private static CloseableHttpClient init() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setConnectionManager((HttpClientConnectionManager)ApacheHttpUtil.initHttpClientPool());
        Integer connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 3000);
        Integer readTimeout = Integer.getInteger("httpclient.readTimeout", 5000);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder.setConnectionRequestTimeout(30000);
        requestBuilder.setConnectTimeout(connectionTimeout.intValue());
        requestBuilder.setSocketTimeout(readTimeout.intValue());
        builder.setDefaultRequestConfig(requestBuilder.build());
        return builder.build();
    }

    private static PoolingHttpClientConnectionManager initHttpClientPool() {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(10);
        poolingHttpClientConnectionManager.setMaxTotal(100);
        return poolingHttpClientConnectionManager;
    }
}

