/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn.ext.apachehttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.misc.NetUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;

public class WrapResponse
implements ResponseHandler<Map<String, Object>> {
    private String url;

    public WrapResponse(String url) {
        this.url = url;
    }

    public Map<String, Object> handleResponse(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code >= 200 && code < 400) {
            HashMap<String, Object> returns = new HashMap<String, Object>(4);
            Map<String, Object> headerMap = this.initHeaderMap(response.getAllHeaders());
            returns.put("headers", headerMap);
            returns.put("result", this.getContent(response));
            returns.put("responseCode", code);
            return returns;
        }
        throw CommonError.UNKNOWN_SERVER_ERROR.create(new String[]{this.getContent(response), WrapResponse.trimURL(this.url), String.valueOf(code)});
    }

    public Map<String, Object> initHeaderMap(Header[] allHeaders) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>(allHeaders.length);
        for (Header header : allHeaders) {
            String headerName = header.getName() == null ? "" : header.getName();
            headerMap.put(headerName, header.getValue());
        }
        return headerMap;
    }

    private static String trimURL(String url) {
        int i;
        if (url != null && (i = url.indexOf(63)) > 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    public String getContent(HttpResponse response) throws IOException {
        HttpEntity resEntity = response.getEntity();
        if (resEntity == null) {
            return null;
        }
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader != null && this.isGzipType(respHeader)) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            InputStream in = gzipEntity.getContent();
            return NetUtil.readText((InputStream)in);
        }
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    private boolean isGzipType(Header respHeader) {
        return "gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue());
    }
}

