/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Hex;

public class FileResourceUtil {
    public static String getEntityTitle(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString() + "(" + entity + ")";
    }

    public static Object parseResPK(String pk, String entity) {
        if (Hex.isNumber((String)pk) && pk.length() <= 19) {
            return Long.parseLong(pk);
        }
        return pk;
    }

    public static String getEntityName(String entityTitle) {
        int i = entityTitle.lastIndexOf(40);
        int j = entityTitle.lastIndexOf(41);
        return entityTitle.substring(i + 1, j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParsed(long id, String remark) {
        String sql = "UPDATE t_iscb_dts_imp_header SET fprogress='PARSED',fstate='READY', fremark=? WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(StringUtil.trim((String)remark, (int)255), id), Arrays.asList(12, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static void setImported(long id, int success, int failed, int omitted, int total) {
        String sql = "UPDATE t_iscb_dts_imp_header SET fprogress=?,fstate=?,fremark=? WHERE fid=?";
        String remark = String.format(ResManager.loadKDString((String)"\u603b\u8ba1\u5904\u7406\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c\u5ffd\u7565\uff1a%3$s\uff1b\u5931\u8d25\uff1a%4$s", (String)"FileResourceUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), total, success, omitted, failed);
        List<Object> values = Arrays.asList("IMPORTED", "SUCCESS", remark, id);
        List<Integer> types = Arrays.asList(12, 12, 12, -5);
        FileResourceUtil.executeSql(sql, values, types);
    }

    static void setImporting(long id) {
        String sql = "UPDATE t_iscb_dts_imp_header SET fprogress=? WHERE fid=?";
        List<Object> values = Arrays.asList("IMPORTING", id);
        List<Integer> types = Arrays.asList(12, -5);
        FileResourceUtil.executeSql(sql, values, types);
    }

    public static void setFailed(long id) {
        String sql = "UPDATE t_iscb_dts_imp_header SET fstate=? WHERE fid=?";
        List<Object> values = Arrays.asList("FAILED", id);
        List<Integer> types = Arrays.asList(12, -5);
        FileResourceUtil.executeSql(sql, values, types);
    }

    static void setCanceled(long id) {
        String sql = "UPDATE t_iscb_dts_imp_header SET fprogress=?,fstate=? WHERE fid=?";
        List<Object> values = Arrays.asList("PAUSED", "CANCELED", id);
        List<Integer> types = Arrays.asList(12, 12, -5);
        FileResourceUtil.executeSql(sql, values, types);
    }

    public static void setEntryState(String table, long entryid, String state, Throwable err) {
        String sql = "UPDATE " + table + " SET fstate=?, fstack_trace = ? WHERE fentryid=?";
        List<Object> values = Arrays.asList(state, StringUtil.toString((Throwable)err), entryid);
        List<Integer> types = Arrays.asList(12, 12, -5);
        FileResourceUtil.executeSql(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeSql(String sql, List<Object> values, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            boolean bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

