/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.ImportResponse;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ImportResourceUtil {
    public static List<Map<String, Object>> doImport(String dts) {
        List<String> jsons = ImportDynamicObject.toList(dts);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(jsons.size());
        for (String dt : jsons) {
            ImportResponse response = ImportResourceUtil.executeImport(dt);
            result.add(response.toMap());
        }
        return result;
    }

    private static ImportResponse executeImport(String dt) {
        Map dtMap = (Map)Json.toObject((String)dt);
        Object id = dtMap.get("$id");
        String entityName = dtMap.get("$entityname").toString();
        boolean isref = (Boolean)dtMap.get("$isref");
        String number = D.s(dtMap.get("number"));
        String name = D.s(dtMap.get("name"));
        boolean existed = DynamicObjectUtil.inDb(id, entityName);
        if (isref && existed) {
            String omittedMsg = ResManager.loadKDString((String)"\u8be5\u8d44\u6e90\u5bfc\u5165\u65b9\u5f0f\u4e3a\u201c\u5173\u8054\u201d\u6a21\u5f0f\uff0c\u5e76\u4e14\u7cfb\u7edf\u5185\u5df2\u5b58\u5728\u8be5\u8d44\u6e90\uff0c\u5219\u5ffd\u7565\u5bfc\u5165\u3002", (String)"ImportResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            ImportResponse response = new ImportResponse(id, entityName, number, name, "omitted", isref);
            response.setOmittedMessage(omittedMsg);
            return response;
        }
        try {
            ImportDynamicObject.innerImport(Collections.singletonList(dt));
            return new ImportResponse(id, entityName, number, name, "success", isref);
        }
        catch (Exception e) {
            ImportResponse response = new ImportResponse(id, entityName, number, name, "failed", isref);
            response.setError(StringUtil.getCascadeMessage((Throwable)e));
            return response;
        }
    }
}

