/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;

public class SolutionSyncCloudUtil {
    private static final Log LOGGER = LogFactory.getLog(SolutionSyncCloudUtil.class);
    private static final String UPLOAD_SOLUTION_STATISTICS = "kapi/v2/kdec/kdec_eip_resource/kdec_eip_resource/uploadSolutionStatistics";
    private static final String DEPLOYSTATISTICS = "deployStatistics";
    private static final String DOWNLOADSTATISTICS = "downloadStatistics";
    private static final String CLICKSTATISTICS = "clickStatistics";
    private static final String FEEDBACK = "feedback";
    private static final String ENJOY = "enjoy";
    private static final String GET_ENJOY_COUNT = "getEnjoyCount";
    private static final String GET_CLOUD_SOLUTION = "getCloudSolution";
    private static final String GET_USER_ENJOY = "getUserEnjoy";
    private static final String CHECKAPI = "checkApi";

    public static void uploadSolutionDeployInfo(long id, int success, int failed, int omitted, String status) {
        try {
            long solutionId = SolutionSyncCloudUtil.getSolutionId(id);
            if (solutionId > 0L) {
                Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
                String url = SolutionSyncCloudUtil.getServerUrl(appInfo);
                Map<String, Object> params = SolutionSyncCloudUtil.buildUploadSolutionDeployParam(solutionId, success, failed, omitted, status);
                SolutionSyncCloudUtil.sendHttRequest(appInfo, url, params);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("\u4e0a\u4f20\u4e91\u7aef\u65b9\u6848\u5305\u90e8\u7f72\u7edf\u8ba1\u63a5\u53e3\u5931\u8d25,\u90e8\u7f72ID\uff1a" + id, t);
        }
    }

    public static void uploadSolutionDownLoadInfo(List<Long> solutionIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", solutionIds);
        SolutionSyncCloudUtil.uploadSolutionApi(params, DOWNLOADSTATISTICS);
    }

    public static void uploadSolutionClickInfo(long solutionId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", solutionId);
            SolutionSyncCloudUtil.uploadSolutionApi(params, CLICKSTATISTICS);
        }
        catch (Throwable t) {
            LOGGER.warn("\u4e0a\u4f20\u4e91\u7aef\u65b9\u6848\u5305\u70b9\u51fb\u7edf\u8ba1\u63a5\u53e3\u5931\u8d25,\u65b9\u6848ID\uff1a" + solutionId, t);
        }
    }

    public static void uploadSolutionFeedBackInfo(long solutionId, Map<String, Object> params) {
        params.put("id", solutionId);
        SolutionSyncCloudUtil.uploadSolutionApi(params, FEEDBACK);
    }

    public static Map uploadSolutionEnjoy(long solutionId, Map<String, Object> params) {
        params.put("id", solutionId);
        return SolutionSyncCloudUtil.uploadSolutionApi(params, ENJOY);
    }

    public static Map getEnjoyCount(long solutionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", solutionId);
        return SolutionSyncCloudUtil.uploadSolutionApi(params, GET_ENJOY_COUNT);
    }

    public static Map uploadSolutionApi(Map<String, Object> params, String command) {
        Map<String, Object> param;
        String url;
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String result = SolutionSyncCloudUtil.sendHttRequest(appInfo, url = SolutionSyncCloudUtil.getServerUrl(appInfo), param = SolutionSyncCloudUtil.buildCommonParam(params, command));
        Map res = (Map)Script.parseJson((String)result);
        if (res != null && ("400".equals(D.s(res.get("errorCode"))) || "401".equals(D.s(res.get("errorCode"))))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u901a\u8fc7\u3010\u96c6\u6210\u670d\u52a1\u4e91\u3011\u2192\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011\u2192\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u7533\u8bf7\u516c\u5171\u8d44\u6e90\u4e91\u8d44\u6e90\u8bbf\u95ee\u6743\u9650", (String)"SolutionSyncCloudUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (res != null && "-1".equals(D.s(res.get("errorCode")))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e91\u7aefAPI\u8bf7\u6c42\u5931\u8d25\uff0c%s", (String)"SolutionSyncCloudUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s(res.get("message"))));
        }
        return res;
    }

    public static List<Map<String, Object>> queryCloudSolutionList(String api, Map<String, Object> params) {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String serverUrl = D.s((Object)appInfo.get("server_url"));
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        String url = serverUrl + api;
        Map<String, Object> headers = PublicResourceUtil.getHeaders(appInfo, params);
        headers.put("Accept", "application/json");
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        byte[] bs = JSON.toJSONString(params).getBytes(StandardCharsets.UTF_8);
        InputStream in = NetUtil.httpAccess((String)url, (String)"POST", (byte[])bs, (String)"application/json", (NetUtil.ConnectionDecorator)decorator, (int)NetUtil.TIMEOUT);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return SolutionSyncCloudUtil.getResult(reader);
    }

    public static String sendHttRequest(Map<String, Object> appInfo, String url, Map<String, Object> param) {
        Map<String, Object> headers = PublicResourceUtil.getHeaders(appInfo, param);
        headers.put("Accept", "application/json");
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        byte[] bs = JSON.toJSONString(param).getBytes(StandardCharsets.UTF_8);
        InputStream in = NetUtil.httpAccess((String)url, (String)"POST", (byte[])bs, (String)"application/json", (NetUtil.ConnectionDecorator)decorator, (int)NetUtil.TIMEOUT);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return NetUtil.readText((Reader)reader);
    }

    private static Map<String, Object> buildUploadSolutionDeployParam(long solutionId, int success, int failed, int omitted, String status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", status);
        params.put("successCount", success);
        params.put("failedCount", failed);
        params.put("omittedCount", omitted);
        params.put("id", solutionId);
        return SolutionSyncCloudUtil.buildCommonParam(params, DEPLOYSTATISTICS);
    }

    private static Map<String, Object> buildCommonParam(Map<String, Object> params, String command) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        params.put("command", command);
        params.put("tenantId", tenantId);
        params.put("accountId", accountId);
        params.put("timestamp", System.currentTimeMillis());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", params);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSolutionId(long id) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT fres_id FROM t_iscb_dts_imp_header WHERE fid = ? and fres_type like '%(isc_solution_center_m)'";
            List<Long> params = Collections.singletonList(id);
            List<Integer> types = Collections.singletonList(-5);
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, params, types);
            if (row != null && D.l((Object)row.get((Object)"fres_id")) > 0L) {
                long l = D.l((Object)row.get((Object)"fres_id"));
                return l;
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return 0L;
    }

    private static String getServerUrl(Map<String, Object> appInfo) {
        String serverUrl = D.s((Object)appInfo.get("server_url"));
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        return serverUrl + UPLOAD_SOLUTION_STATISTICS;
    }

    public static Map getCloudSolution(Map<String, Object> queryParam) {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String url = SolutionSyncCloudUtil.getServerUrl(appInfo);
        queryParam.put("command", GET_CLOUD_SOLUTION);
        queryParam.put("timestamp", System.currentTimeMillis());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("content", queryParam);
        String result = SolutionSyncCloudUtil.sendHttRequest(appInfo, url, param);
        Map res = (Map)Script.parseJson((String)result);
        if (res != null && ("400".equals(D.s(res.get("errorCode"))) || "401".equals(D.s(res.get("errorCode"))))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u901a\u8fc7\u3010\u96c6\u6210\u670d\u52a1\u4e91\u3011\u2192\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011\u2192\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u7533\u8bf7\u516c\u5171\u8d44\u6e90\u4e91\u8d44\u6e90\u8bbf\u95ee\u6743\u9650", (String)"SolutionSyncCloudUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (res != null && "-1".equals(D.s(res.get("errorCode")))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e91\u7aefAPI\u8bf7\u6c42\u5931\u8d25\uff0c%s", (String)"SolutionSyncCloudUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s(res.get("message"))));
        }
        return res;
    }

    public static boolean getCurrentUserEnjoy(long solutionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enjoyId", RequestContext.get().getCurrUserId());
        params.put("id", solutionId);
        Map map = SolutionSyncCloudUtil.uploadSolutionApi(params, GET_USER_ENJOY);
        return map == null ? false : D.x(map.get("data"));
    }

    private static List<Map<String, Object>> getResult(Reader reader) {
        try {
            String result = NetUtil.readText((Reader)reader);
            Map res = (Map)Script.parseJson((String)result);
            if (D.x(res.get("status"))) {
                List list = (List)((Map)res.get("data")).get("rows");
                return list;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u83b7\u53d6\u7684\u4e91\u7aef\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f:%s", (String)"SolutionSyncCloudUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), res));
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    public static boolean checkCloudApi(long solutionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", solutionId);
        Map map = SolutionSyncCloudUtil.uploadSolutionApi(params, CHECKAPI);
        return map == null ? false : D.x(map.get("data"));
    }
}

