/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.MutexTaskManager;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.data.Counter;
import kd.isc.iscb.util.dt.D;

public class CheckIfSystemIsBusy
implements DaemonTask {
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(CheckIfSystemIsBusy.class);
    private static final DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ISCB_BUSY_SIGN");
    private static final int INTERVALS = 10;
    private Counter smallTaskCounter = new Counter(60000, 10);
    private Counter bigTaskCounter = new Counter(60000, 10);
    private Counter mutexTaskCounter = new Counter(60000, 10);
    private int smallTaskThreshold = D.i((Object)System.getProperty("smallTaskThreshold"));
    private int bigTaskThreshold;
    private Counter printCounter;
    private String notifyKey;

    public CheckIfSystemIsBusy() {
        if (this.smallTaskThreshold <= 0) {
            this.smallTaskThreshold = 100;
        }
        this.bigTaskThreshold = D.i((Object)System.getProperty("bigTaskThreshold"));
        if (this.bigTaskThreshold <= 0) {
            this.bigTaskThreshold = 50;
        }
        this.printCounter = new Counter(90000, 10);
        this.notifyKey = "ISC_IS_BUSY:" + Instance.getClusterName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.smallTaskCounter.set(LightTaskManager.getQueueSize() + 1);
            this.bigTaskCounter.set(TaskManager.getQueueSize() + 1);
            this.mutexTaskCounter.set(MutexTaskManager.getQueueSize() + 1);
            this.check();
        }
        catch (Throwable e) {
            logger.warn("check_if_system_is_busy_failed", e);
        }
        finally {
            ScheduleManager.submit((Task)this, 60);
        }
    }

    private void check() {
        if (this.isBusy()) {
            if (this.printCounter.get() <= 0) {
                logger.warn("ISC_IS_BUSY!\u96c6\u6210\u4e91\u8282\u70b9\u7e41\u5fd9\u3002\u8fd110\u5206\u949f\u4ee5\u6765\u5e73\u5747\u6bcf\u5206\u949f\u6392\u961f\u4efb\u52a1\u6570\u4e3a\uff1a\uff08\u5927\u4efb\u52a1\uff1a" + this.bigTaskCounter.avg() + "\u4e2a\uff09\uff08\u5c0f\u4efb\u52a1\uff1a" + this.smallTaskCounter.avg() + "\u4e2a\uff09\uff0c\u8bf7\u53ca\u65f6\u589e\u52a0\u8282\u70b9\u6d88\u8d39\u3002");
                distributeSessionlessCache.put(this.notifyKey, (Object)"true", 900);
                this.printCounter.inc(1);
            }
        } else if (distributeSessionlessCache.contains(this.notifyKey)) {
            distributeSessionlessCache.remove(this.notifyKey);
            logger.warn("\u96c6\u6210\u4e91\u8282\u70b9\u4e0d\u518d\u7e41\u5fd9\u3002\u8fd110\u5206\u949f\u4ee5\u6765\u5e73\u5747\u6bcf\u5206\u949f\u6392\u961f\u4efb\u52a1\u6570\u4e3a\uff1a\uff08\u5927\u4efb\u52a1\uff1a" + this.bigTaskCounter.avg() + "\u4e2a\uff09\uff08\u5c0f\u4efb\u52a1\uff1a" + this.smallTaskCounter.avg() + "\u4e2a\uff09\uff0c\u79fb\u9664redis\u901a\u77e5key\uff1a" + this.notifyKey);
        }
    }

    private boolean isBusy() {
        return this.smallTaskCounter.avg() > this.smallTaskThreshold || this.bigTaskCounter.avg() > this.bigTaskThreshold || this.mutexTaskCounter.avg() > this.bigTaskThreshold;
    }
}

