/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.job.AbstractJobProxy;
import kd.isc.iscb.platform.core.job.Const;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobCleaner;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobMonitor;
import kd.isc.iscb.platform.core.job.JobProgress;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.job.LightJobProxy;
import kd.isc.iscb.platform.core.job.MutexJobProxy;
import kd.isc.iscb.platform.core.job.NormalJobProxy;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.MutexTaskManager;
import kd.isc.iscb.platform.core.task.OutOfTaskQueueException;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Triple;

class JobLoader
implements Task,
Const {
    private static final ReadLockFreeMap<String, JobLoader> tasks = new ReadLockFreeMap();
    private String id = UUID.randomUUID().toString();
    private volatile long scheduledTime = System.currentTimeMillis() + 500L;
    private int failedCount = 0;
    private static Log logger = LogFactory.getLog(JobProgress.class);

    JobLoader() {
    }

    static void notify(long scheduledTime) {
        JobLoader loader = JobLoader.getLoader();
        loader.innerNotify(scheduledTime, false);
    }

    static JobLoader getLoader() {
        JobLoader tmp;
        String key = RequestContext.get().getAccountId();
        JobLoader loader = (JobLoader)tasks.get((Object)key);
        if (loader == null && (tmp = new JobLoader()) == (loader = (JobLoader)tasks.putIfAbsent((Object)key, (Object)tmp))) {
            ScheduleManager.submit((Task)loader, 1);
            ScheduleManager.submit((Task)new JobMonitor(), 600);
            ScheduleManager.submit((Task)new JobCleaner(), 3600);
        }
        return loader;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        if (now > this.scheduledTime) {
            try {
                this.innerNotify(Long.MAX_VALUE, true);
                this.innerNotify(JobLoader.loadReadyJobs(), false);
                this.failedCount = 0;
            }
            catch (Throwable e) {
                logger.warn("isc_job_loader_failed", e);
                this.scheduledTime = now + (long)(1800000 * ++this.failedCount);
            }
        }
        ScheduleManager.submit((Task)this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long loadReadyJobs() {
        block6: {
            reader = null;
            cn = TX.getConnection((String)"ISCB", (boolean)false);
            try {
                deadline = System.currentTimeMillis() + 500L;
                time = new Timestamp(deadline + 1800000L);
                sql = "SELECT fid,fstate,ftype,ftitle,fparam,fparam_tag,fscheduled_time,fcreator,flang FROM t_isc_job_inst WHERE fstate IN ('CREATED','WAITING','READY') and fscheduled_time<=? ORDER BY fscheduled_time";
                reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.singletonList(time), Collections.singletonList(93));
                row = (DataRow)reader.read();
lbl9:
                // 2 sources

                while (row != null) {
                    block7: {
                        scheduledTime = D.t((Object)row.get((Object)"fscheduled_time"));
                        if (scheduledTime.getTime() > deadline) break block7;
                        try {
                            JobLoader.enqueueJob(row);
                        }
                        catch (Throwable e) {
                            JobLoader.handleException(row, e);
                        }
                        ** GOTO lbl-1000
                    }
                    var8_9 = scheduledTime.getTime();
                    break block6;
                }
                ** GOTO lbl32
            }
            catch (Throwable var10_10) {
                DbUtil.close(reader);
                DbUtil.close((Connection)cn, (boolean)true);
                throw var10_10;
            }
        }
        DbUtil.close((ObjectReader)reader);
        DbUtil.close((Connection)cn, (boolean)true);
        return var8_9;
lbl-1000:
        // 2 sources

        {
            row = (DataRow)reader.read();
            ** GOTO lbl9
lbl32:
            // 1 sources

            var6_6 = time.getTime();
        }
        DbUtil.close((ObjectReader)reader);
        DbUtil.close((Connection)cn, (boolean)true);
        return var6_6;
    }

    private static void handleException(DataRow row, Throwable e) {
        if (e instanceof OutOfTaskQueueException) {
            throw (OutOfTaskQueueException)((Object)e);
        }
        long jobId = D.l((Object)row.get((Object)"fid"));
        logger.warn("isc_job_loader_failed,id=" + jobId, e);
        JobState.setFailed(jobId, e);
    }

    private static void enqueueJob(DataRow row) throws SQLException {
        String creator;
        Job job = JobLoader.restoreJob(row);
        long jobId = D.l((Object)row.get((Object)"fid"));
        if (JobState.CREATED.name().equals(row.get((Object)"fstate"))) {
            JobState.setReady(jobId);
        }
        if ((creator = D.s((Object)row.get((Object)"fcreator"))) == null || "0".equals(creator)) {
            JobLoader.enqueueDirectly(jobId, job);
        } else {
            RequestContext ctx = ProxyUserUtil.createRequestContext(RequestContext.get(), creator, JobLoader.getLang(row));
            JobLoader.enqueueDirectly(jobId, job, ctx);
        }
    }

    private static Lang getLang(DataRow row) {
        String s = D.s((Object)row.get((Object)"flang"));
        if (s == null || "null".equals(s)) {
            return Lang.defaultLang();
        }
        return Lang.valueOf((String)s);
    }

    private static Job restoreJob(DataRow row) {
        String type = (String)row.get((Object)"ftype");
        String title = (String)row.get((Object)"ftitle");
        String param = D.s((Object)row.get((Object)"fparam_tag"));
        if (param == null) {
            param = (String)row.get((Object)"fparam");
        }
        Job job = JobEngine.getFactory(type).restore(title, param);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Triple<Job, String, Lang> restore(long id) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT fid,fstate,ftype,ftitle,fparam,fparam_tag,fscheduled_time,fcreator,flang FROM t_isc_job_inst WHERE fid=?";
            DataRow data = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(id), Collections.singletonList(-5));
            if (data == null) {
                Triple<Job, String, Lang> triple = null;
                return triple;
            }
            Job job = JobLoader.restoreJob(data);
            String creator = D.s((Object)data.get((Object)"fcreator"));
            Lang lang = JobLoader.getLang(data);
            Triple triple = new Triple((Object)job, (Object)creator, (Object)lang);
            return triple;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    static void enqueueDirectly(long jobId, Job job) {
        JobLoader.enqueueDirectly(jobId, job, RequestContext.get());
    }

    static void enqueueDirectly(long jobId, Job job, RequestContext ctx) {
        String account = RequestContext.get().getAccountId();
        if (job.getMutex() != 0L) {
            MutexTaskManager.submit(new MutexJobProxy(account, jobId, job), ctx);
        } else if (job.isLightTask()) {
            LightTaskManager.submit(new LightJobProxy(account, jobId, job), ctx);
        } else {
            TaskManager.submit(new NormalJobProxy(account, jobId, job), ctx);
        }
    }

    static void reschedule(long jobId, Job job, int seconds) {
        String account = RequestContext.get().getAccountId();
        AbstractJobProxy task = job.isLightTask() ? new LightJobProxy(account, jobId, job) : new NormalJobProxy(account, jobId, job);
        ScheduleManager.submit((Task)task, seconds);
    }

    private synchronized void innerNotify(long scheduledTime, boolean force) {
        if (scheduledTime < this.scheduledTime || force) {
            this.scheduledTime = scheduledTime;
        }
    }
}

