/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.Const;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobLoader;
import kd.isc.iscb.platform.core.job.JobProgress;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;

final class JobMonitor
implements Task,
Const {
    protected static final int INTERVAL = 600;
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(JobProgress.class);

    JobMonitor() {
    }

    @Override
    public void run() {
        if (JobEngine.isMaster()) {
            this.resetInterruptedJobs();
        }
        ScheduleManager.submit((Task)this, 600);
    }

    private void resetInterruptedJobs() {
        try {
            if (JobState.resetInterruptedJobs()) {
                JobLoader.notify(System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            logger.warn("isc_job_monitor_failed", e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

