/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.MutexTaskManager;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.util.ContextUtil;

public class JobNotifier
implements DaemonTask {
    private String id = UUID.randomUUID().toString();
    private static Random rnd = new Random();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            Set<String> accounts = TaskManager.getBusyAccounts();
            accounts.addAll(LightTaskManager.getBusyAccounts());
            accounts.addAll(MutexTaskManager.getBusyAccounts());
            if (!accounts.isEmpty()) {
                JobNotifier.notifyAll(accounts);
            }
        }
        finally {
            ScheduleManager.submit((Task)this, 180);
        }
    }

    public static void notifyAll(Collection<String> accounts) {
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)JobNotifier.class.getName(), (String)"notifyJobLoader", (Object[])new String[]{accounts.toString()});
    }

    public static void notifyJobLoader(String busyAccounts) {
        RequestContext current = RequestContext.get();
        try {
            JobNotifier.innerNotifyLoaders(busyAccounts);
        }
        finally {
            JobNotifier.restoreContext(current);
        }
    }

    private static void restoreContext(RequestContext current) {
        if (current != null) {
            RequestContextCreator.restoreForMQ((RequestContext)current);
        }
    }

    private static void innerNotifyLoaders(String busyAccounts) {
        for (Account c : AccountUtils.getAllAccountsOfCurrentEnv()) {
            if (!busyAccounts.contains(c.getAccountId())) continue;
            RequestContext ctx = ContextUtil.createRequestContext(c.getAccountId(), c.getTenantId());
            RequestContextCreator.restoreForMQ((RequestContext)ctx);
            JobEngine.notify(System.currentTimeMillis() + (long)rnd.nextInt(30000));
        }
    }
}

