/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.connector.server.ThreadDump;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.misc.Triple;

public final class JobProgress
implements DaemonTask {
    protected static final int REFRESH_INTERVAL = 7;
    private static final ReadLockFreeMap<String, JobProgress> tasks = new ReadLockFreeMap();
    private String id = UUID.randomUUID().toString();
    private ConcurrentHashMap<Long, Triple<Job, Thread, RequestContext>> jobs = new ConcurrentHashMap();
    private int count;
    private static Log logger = LogFactory.getLog(JobProgress.class);
    private static final IAppCache cache = AppCache.get((String)"ISCB");

    static void regRunning(long id, Job job) {
        JobProgress progress = JobProgress.getProgress();
        progress.put(id, job);
    }

    static void unregRunning(long id) {
        JobProgress progress = JobProgress.getProgress();
        progress.remove(id);
    }

    private static JobProgress getProgress() {
        JobProgress tmp;
        String key = RequestContext.get().getAccountId();
        JobProgress progress = (JobProgress)tasks.get((Object)key);
        if (progress == null && (tmp = new JobProgress()) == (progress = (JobProgress)tasks.putIfAbsent((Object)key, (Object)tmp))) {
            ScheduleManager.submit((Task)progress, 3);
        }
        return progress;
    }

    private void put(long id, Job job) {
        this.jobs.put(id, (Triple<Job, Thread, RequestContext>)new Triple((Object)job, (Object)Thread.currentThread(), (Object)RequestContext.get()));
    }

    private void remove(long id) {
        this.jobs.remove(id);
        try {
            cache.remove(JobProgress.getCacheKey(id));
        }
        catch (Throwable e) {
            logger.warn("job_progress_cache_failed", e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext current = RequestContext.get();
        try {
            boolean refreshJobState = ++this.count % 7 == 0;
            for (Map.Entry<Long, Triple<Job, Thread, RequestContext>> e : this.jobs.entrySet()) {
                RequestContextCreator.restoreForMQ((RequestContext)((RequestContext)e.getValue().getC()));
                this.refreshProgress(e, refreshJobState);
            }
        }
        catch (Throwable e) {
            logger.warn("job_progress_failed", e);
        }
        finally {
            RequestContextCreator.restoreForMQ((RequestContext)current);
            ScheduleManager.submit((Task)this, 3);
        }
    }

    private void refreshProgress(Map.Entry<Long, Triple<Job, Thread, RequestContext>> e, boolean refreshJobState) {
        long jobId = e.getKey();
        Job job = (Job)e.getValue().getA();
        try {
            Job.Progress progress = job.getRealtimeProgress();
            if (progress != null) {
                cache.put(JobProgress.getCacheKey(jobId), (Object)progress.toString());
            }
            if (refreshJobState) {
                JobState.setProgress(jobId, job.refreshProgress());
            }
        }
        catch (Throwable err) {
            logger.warn("job_progress_failed, id=" + jobId + ", title=" + job.getTitle(), err);
        }
    }

    private static String getCacheKey(long jobId) {
        return String.valueOf(jobId);
    }

    static Job.Progress getProgress(long jobId) {
        String json = (String)cache.get(JobProgress.getCacheKey(jobId), String.class);
        if (json == null) {
            return null;
        }
        return Job.Progress.restore(json);
    }

    public static boolean dumpStackTrace(long jobId) {
        Triple<Job, Thread, RequestContext> p = JobProgress.getProgress().jobs.get(jobId);
        if (p == null) {
            return false;
        }
        String stackTrace = ThreadDump.dump((Thread)((Thread)p.getB()));
        JobState.saveStackTrace(jobId, stackTrace);
        return true;
    }
}

