/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job.c;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.UUID;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;

public class JobServerCleaner
implements DaemonTask {
    private static final long KEEP_TIME = 86400000L;
    public static final int REFRESH_INTERVAL = 7200;
    private Table table;
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    @Override
    public void run() {
        try {
            this.deleteObsoleteInstances();
        }
        catch (Throwable e) {
            logger.warn("refresh_isc_server_state_failed", e);
        }
        ScheduleManager.submit((Task)this, 7200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteObsoleteInstances() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            this.getTable(cn);
            String sql = "DELETE FROM T_ISCB_SERVER_INSTANCE WHERE flast_modified_time<?";
            Timestamp time = new Timestamp(System.currentTimeMillis() - 86400000L);
            DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(time), Collections.singletonList(93));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private Table getTable(Connection cn) {
        Table table = this.table;
        if (table == null) {
            this.table = table = new Table(cn, "T_ISCB_SERVER_INSTANCE", ' ');
        }
        return table;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

