/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job.c;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.job.c.JobMutexLoader;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class JobServerState
implements DaemonTask {
    public static final int REFRESH_INTERVAL = 1200;
    private static final Timestamp START_TIME = new Timestamp(System.currentTimeMillis());
    private Table table;
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    @Override
    public void run() {
        try {
            this.refreshState();
        }
        catch (Throwable e) {
            logger.warn("refresh_isc_server_state_failed", e);
        }
        finally {
            ScheduleManager.submit((Task)this, 1200);
        }
    }

    private void refreshState() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            this.refreshServerInstanceState(cn);
            this.refreshJobMutexState(cn);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void refreshJobMutexState(Connection cn) {
        String sql = "UPDATE t_isc_job_mutex_instance SET flast_modified_time = ? WHERE finstance = ?";
        List<Object> params = Arrays.asList(new Timestamp(System.currentTimeMillis()), TaskManager.getInstanceId());
        List<Integer> types = Arrays.asList(93, 12);
        DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
    }

    private void refreshServerInstanceState(Connection cn) {
        Map<String, Object> data;
        Table table = this.getTable(cn);
        if (!TableUtil.update((Connection)cn, (Table)table, data = this.prepareData())) {
            TableUtil.insert((Connection)cn, (Table)table, data);
        }
    }

    private Map<String, Object> prepareData() {
        String finstance_id = TaskManager.getInstanceId();
        RequestContext context = RequestContext.get();
        String accountId = context.getAccountId();
        String appIds = JobMutexLoader.getAppIds();
        String clusterName = Instance.getClusterName();
        String mqTag = System.getProperty("mq.debug.queue.tag");
        long fid = Hash.md5i64((byte[])finstance_id.getBytes(D.UTF_8));
        String fip = NetUtil.getServerId();
        String fis_online = "1";
        Timestamp flast_modified_time = new Timestamp(System.currentTimeMillis());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("finstance_id", finstance_id);
        data.put("fid", fid);
        data.put("fip", fip);
        data.put("fis_online", fis_online);
        data.put("flast_modified_time", flast_modified_time);
        data.put("fstart_time", START_TIME);
        String deployInfo = StringUtil.trim((String)(accountId + "/" + appIds + "/" + clusterName + "/mq_tag:" + mqTag), (int)150);
        data.put("fdeploy_info", deployInfo);
        return data;
    }

    private Table getTable(Connection cn) {
        Table table = this.table;
        if (table == null) {
            this.table = table = new Table(cn, "T_ISCB_SERVER_INSTANCE", ' ');
        }
        return table;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

