/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job.pbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.pbc.LogUtil;
import kd.isc.iscb.platform.core.job.pbc.PbcLogConfigItem;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;

public class PbcInstCleaner
implements DaemonTask {
    private static final Log logger = LogFactory.getLog(PbcInstCleaner.class);
    private static final String checkSql = "select count(fid) as total_count, sum(fcontext_length) as total_size from t_pbc_flow_inst;";
    private static final String selectOldDataSql = "select top 500 fid from t_pbc_flow_inst where fstate in ('Complete','Terminated','Failed') order by fmodified_time asc;";
    private String id = "PBC_C:" + RequestContext.get().getAccountId();
    private int totalCount;
    private long totalSize;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        if (this.isNotReady()) {
            return;
        }
        if (!JobEngine.isMaster()) {
            ScheduleManager.submit((Task)this, 120);
        } else {
            this.innerCleanJob();
            ScheduleManager.submit((Task)this, 3600);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotReady() {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select count(*) as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_PBC_FLOW_INST'";
            boolean bl = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql)) == 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCleanJob() {
        PbcLogConfigItem config = LogUtil.getConfig();
        logger.info("\u5f00\u59cb\u6e05\u7406PBC\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u5141\u8bb8\u7684\u6700\u5927\u4fdd\u7559\u884c\u6570\uff1a" + config.getMaxLogCount() + "\uff0c\u6700\u5927\u5b57\u8282\u6570\uff1a" + config.getMaxLogSize());
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            this.resetTotalCountAndSize(cn);
            if (this.totalCount > config.getMaxLogCount()) {
                this.deleteWhenLogCountExceed(config, cn);
            } else {
                this.deleteWhenLogSizeExceed(config, cn);
            }
        }
        catch (Throwable e) {
            logger.warn("\u6e05\u7406PBC\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u751f\u5f02\u5e38\uff1a", e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void deleteWhenLogSizeExceed(PbcLogConfigItem config, Connection cn) {
        long totalCleanCount = 0L;
        while (this.totalSize > config.getMaxLogSize()) {
            totalCleanCount += (long)this.executeCleanSql(cn);
            this.resetTotalCountAndSize(cn);
        }
        logger.info("\u7ed3\u675f\u6e05\u7406PBC\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u603b\u6e05\u7406\u6570\u636e\u884c\u6570\uff1a" + totalCleanCount);
    }

    private void deleteWhenLogCountExceed(PbcLogConfigItem config, Connection cn) {
        int needDeletedCount = this.totalCount - config.getMaxLogCount();
        long totalCleanCount = 0L;
        for (int i = 0; i < needDeletedCount; i += 500) {
            int deleted = this.executeCleanSql(cn);
            totalCleanCount += (long)deleted;
        }
        logger.info("\u7ed3\u675f\u6e05\u7406PBC\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u603b\u6e05\u7406\u6570\u636e\u884c\u6570\uff1a" + totalCleanCount);
    }

    private int executeCleanSql(Connection cn) {
        ArrayList<Object> ids = new ArrayList<Object>(500);
        ArrayList<Integer> types = new ArrayList<Integer>(500);
        String deleteSql = this.generateDeleteSql(cn, ids, types);
        if (ids.size() > 0) {
            int count = DbUtil.executeUpdate((Connection)cn, (String)deleteSql, ids, types);
            this.commit(cn);
            return count;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateDeleteSql(Connection cn, List<Object> ids, List<Integer> types) {
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)selectOldDataSql, Collections.emptyList(), Collections.emptyList());
        try {
            String string = this.constructDeleteSql((ObjectReader<DataRow>)reader, ids, types);
            return string;
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private String constructDeleteSql(ObjectReader<DataRow> reader, List<Object> ids, List<Integer> types) {
        StringBuilder sb = new StringBuilder("delete from t_pbc_flow_inst where fid in(");
        DataRow row = (DataRow)reader.read();
        while (row != null) {
            if (!ids.isEmpty()) {
                sb.append(',');
            }
            ids.add(row.get((Object)"fid"));
            sb.append('?');
            types.add(-5);
            row = (DataRow)reader.read();
        }
        sb.append(')');
        return sb.toString();
    }

    private void commit(Connection cn) {
        try {
            if (cn != null && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e);
        }
    }

    private void resetTotalCountAndSize(Connection cn) {
        DataRow row = DbUtil.executeRow((Connection)cn, (String)checkSql);
        this.totalCount = D.i((Object)row.get((Object)"total_count"));
        this.totalSize = D.l((Object)row.get((Object)"total_size"));
        logger.info("\u5f53\u524d\u603b\u884c\u6570\uff1a" + this.totalCount + "\uff0c\u603b\u5b57\u8282\u6570\uff1a" + this.totalSize);
    }
}

