/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.license.ImportWhiteListFromLocalOnceJobFactory;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.ClassInfo;
import kd.isc.iscb.util.script.misc.log.Logger;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class ImportWhiteListFromLocalOnceJob
implements Job {
    public static final ImportWhiteListFromLocalOnceJobFactory FACTORY = new ImportWhiteListFromLocalOnceJobFactory();
    private String title;
    private String param;
    private final String _package = "isc/iscb/whitelist";
    private volatile transient String progress;
    private volatile int total;
    private AtomicInteger failedCount = new AtomicInteger(0);
    private AtomicInteger succeedCount = new AtomicInteger(0);
    private AtomicInteger omittedCount = new AtomicInteger(0);

    public ImportWhiteListFromLocalOnceJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.progress;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.getCompleted(), this.progress);
    }

    private int getCompleted() {
        return this.succeedCount.get() + this.omittedCount.get();
    }

    @Override
    public String getJobSummary() {
        if (this.failedCount.get() > 0) {
            return String.format(ResManager.loadKDString((String)"\u603b\u5171%1$s\u4e2a\u767d\u540d\u5355\uff0c\u6210\u529f\u5bfc\u5165%2$s\u4e2a\uff0c\u5ffd\u7565%3$s\u4e2a\u3002", (String)"ImportWhiteListFromLocalOnceJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.succeedCount.get(), this.omittedCount.get()) + "\n" + String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25%s\u4e2a\u3002", (String)"ImportWhiteListFromLocalOnceJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failedCount.get()) + "\n";
        }
        return String.format(ResManager.loadKDString((String)"\u603b\u5171%1$s\u4e2a\u767d\u540d\u5355\uff0c\u6210\u529f\u5bfc\u5165%2$s\u4e2a\uff0c\u5ffd\u7565%3$s\u4e2a\u3002", (String)"ImportWhiteListFromLocalOnceJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.succeedCount.get(), this.omittedCount.get()) + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String url = this.getClass().getClassLoader().getResource("kd/isc/iscb/platform/res/Stub.class").toString();
            Assert.notNull((Object)url, (String)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u5305isc-iscb-platform-res\u672a\u627e\u5230Stub.class\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5305\u662f\u5426\u90e8\u7f72\u6b63\u786e\u3002", (String)"ImportWhiteListFromLocalOnceJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            try (ZipFile zip = ClassInfo.getZipFile((String)url);){
                List<String> exceptions = this.doImporting(zip);
                if (this.failedCount.get() > 0) {
                    throw new IscBizException(this.buildErrorMessage(exceptions));
                }
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public String buildErrorMessage(List<String> exceptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobSummary());
        for (String exception : exceptions) {
            sb.append(exception).append('\n');
        }
        return StringUtil.trim((String)sb.toString(), (int)255);
    }

    private List<String> doImporting(ZipFile zip) throws IOException {
        Enumeration<? extends ZipEntry> it = zip.entries();
        ArrayList<String> exceptions = new ArrayList<String>();
        while (it.hasMoreElements()) {
            ZipEntry e = it.nextElement();
            String name = e.getName();
            if (!this.isRequiredResource(name)) continue;
            SignalManager.checkCancelSignal();
            String dtsFileContent = NetUtil.readText((InputStream)zip.getInputStream(e));
            List<String> dtsList = ImportDynamicObject.toList(dtsFileContent);
            this.total = dtsList.size();
            for (String dts : dtsList) {
                try {
                    Map map = (Map)Json.toObject((String)dts);
                    this.progress = String.format(ResManager.loadKDString((String)"\uff08%1$s/%2$s\uff09\u6b63\u5728\u5bfc\u5165\uff1a%3$s", (String)"ImportWhiteListFromLocalOnceJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getCompleted(), this.total, map.get("name"));
                    if (IscWhiteListUtil.importPreCheckData(map)) {
                        ImportDynamicObject.executeImport(map);
                        this.succeedCount.incrementAndGet();
                        continue;
                    }
                    this.omittedCount.incrementAndGet();
                }
                catch (IscBizException ex) {
                    exceptions.add(this.failedCount.incrementAndGet() + "\u3001" + StringUtil.getCascadeMessage((Throwable)ex));
                    Logger logger = ((LoggerFactory)LoggerFactory.REF.get()).getLogger(ImportWhiteListFromLocalOnceJob.class);
                    logger.warn("imported dts failed," + StringUtil.getCascadeMessage((Throwable)ex), (Throwable)ex);
                }
            }
        }
        return exceptions;
    }

    private boolean isRequiredResource(String name) {
        return name.endsWith(".dts") && name.startsWith("isc/iscb/whitelist");
    }
}

