/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.platform.core.license.IscResourceLicenseUtil;
import kd.isc.iscb.platform.core.license.IscWhiteListItem;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.license.n.TenantSnapshot;
import kd.isc.iscb.util.data.LocalCache;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public class IscLicenseUtil {
    private static final Map<String, String> bizLicenseMap = new HashMap<String, String>();
    private static final LocalCache<Pair<Long, String>, Pair<Long, Boolean>> bizLicenseCache = new LocalCache(8192);

    public static boolean resHasLicense(DynamicObject res) {
        long id;
        String type = res.getDataEntityType().getName();
        if (IscResourceLicenseUtil.hasLicense(type, id = D.l((Object)res.get("id")))) {
            return true;
        }
        IscWhiteListItem item = IscWhiteListItem.get(type, id);
        if (item != null) {
            return item.isValid(res);
        }
        return IscLicenseUtil.hasAppLicense(type, id);
    }

    public static boolean resHasLicense(String type, long id) {
        if (IscResourceLicenseUtil.hasLicense(type, id)) {
            return true;
        }
        IscWhiteListItem item = IscWhiteListItem.get(type, id);
        if (item != null) {
            return item.isValid();
        }
        return IscLicenseUtil.hasAppLicense(type, id);
    }

    private static boolean hasAppLicense(String type, long id) {
        if ("iscx_resource".equals(type)) {
            long now = System.currentTimeMillis();
            Pair key = new Pair((Object)id, (Object)RequestContext.get().getAccountId());
            Pair pair = (Pair)bizLicenseCache.get((Object)key);
            if (pair == null || (Long)pair.getKey() + 600000L < now) {
                pair = new Pair((Object)now, (Object)IscLicenseUtil.verifyAppLicense(type, id));
                bizLicenseCache.put((Object)key, (Object)pair);
            }
            return (Boolean)pair.getValue();
        }
        return false;
    }

    private static boolean verifyAppLicense(String type, long id) {
        DynamicObject res = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)type, (String)"source_app,id");
        String app = D.s((Object)res.getString("source_app"));
        String service = bizLicenseMap.get(app);
        if (service == null) {
            return false;
        }
        Object result = SelfConnectionFactory.invokeService(service, new Object[0]);
        return D.x((Object)result);
    }

    public static boolean mqHasLicense(long connectionId) {
        ConnectionInfo cn;
        String accountId;
        RequestContext current = RequestContext.get();
        TenantInfo tenant = LicenseCache.getTenant();
        AccountInfo account = tenant.getAccount(accountId = current.getAccountId());
        ConnectionInfo connectionInfo = cn = account == null ? null : account.getMqConnection(connectionId);
        if (cn == null) {
            cn = IscLicenseUtil.refreshLicense(connectionId, accountId, true);
        }
        return cn.isValid();
    }

    public static boolean hasLicense(long connectionId) {
        return IscLicenseUtil.hasLicense(connectionId, null, null, null);
    }

    public static boolean hasLicense(long connectionId, String name, String number, String type) {
        ConnectionInfo cn = IscLicenseUtil.getLicense(connectionId, name, number, type);
        return cn.isValid();
    }

    public static ConnectionInfo getLicense(long connectionId, String name, String number, String type) {
        ConnectionInfo cn;
        String accountId;
        RequestContext current = RequestContext.get();
        TenantInfo tenant = LicenseCache.getTenant();
        AccountInfo account = tenant.getAccount(accountId = current.getAccountId());
        ConnectionInfo connectionInfo = cn = account == null ? null : account.getSystemConnection(connectionId);
        if (cn == null) {
            cn = IscLicenseUtil.refreshLicense(connectionId, accountId, false);
        }
        if (type == null || cn.getType().equals(type) && cn.getNumber().equals(number)) {
            return cn;
        }
        throw ConnectorError.CONNECTION_TYPE_NOT_MATCHED.create(new String[]{name, number, type, cn.getName(), cn.getNumber(), cn.getType()});
    }

    private static ConnectionInfo refreshLicense(long connectionId, String accountId, boolean isMQ) {
        ConnectionInfo cn;
        TenantInfo tenant = LicenseCache.refreshTenant2();
        AccountInfo account = tenant.getAccount(accountId);
        if (account == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5957\u4e0b\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u8fde\u63a5\u7684\u914d\u7f6e\u4fe1\u606f\uff01", (String)"IscLicenseUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        ConnectionInfo connectionInfo = cn = isMQ ? account.getMqConnection(connectionId) : account.getSystemConnection(connectionId);
        if (cn == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5957\u4e0b\u6ca1\u6709\u627e\u5230\u8fde\u63a5(%s )\u7684\u914d\u7f6e\u4fe1\u606f\uff01", (String)"IscLicenseUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), connectionId));
        }
        return cn;
    }

    public static boolean hasUnusedLicenseCount() {
        return LicenseCache.getTenant().getUnusedLicenseCount() > 0;
    }

    public static TenantInfo getTenantLicenseInfo() {
        return LicenseCache.getTenant();
    }

    public static void refreshCache() {
        LicenseCache.refreshTenant();
        RequestContext ctx = RequestContext.get();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)LicenseCache.class.getName(), (String)"refreshTenantForMQ", (Object[])new String[]{ctx.getTenantId(), ctx.getAccountId()});
    }

    public static void printTenantLicenseInfo() {
        TenantSnapshot.getInstance().printSnapshot();
    }

    public static void check_PRO_ISCB_License() {
        TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
        int version = tenantLicenseInfo.getLicenseMainVersion();
        if (version < 7) {
            return;
        }
        if (tenantLicenseInfo.getLicenseMode() != 3) {
            return;
        }
        if (tenantLicenseInfo.iscbEnabled()) {
            return;
        }
        IscBizException e = new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u201c\u96c6\u6210\u7ba1\u7406\uff08PRO_ISCB\uff09\u201d\u7279\u6027\u8bb8\u53ef\u3002", (String)"IscLicenseUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        e.setStackTrace(new StackTraceElement[0]);
        throw e;
    }

    static {
        bizLicenseMap.put("epm", "xapi://epm.epdm.EpdmLicenceControlService.check");
    }
}

