/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class IscResourceLicenseUtil {
    private static final ConcurrentHashMap<String, Set<Pair<Long, String>>> cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Set<Pair<Long, String>> syncLicenseState() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT fid,fstate,ftype,fresource_id FROM t_isc_lic_resource ORDER BY fcreatedtime";
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            ArrayList<List> batch = new ArrayList<List>();
            int count = 0;
            HashSet<Pair> licensedRes = new HashSet<Pair>(list.size());
            int max_count = LicenseCache.getTenant().getResourceLicenseCount();
            for (DataRow row : list) {
                String state;
                String string = state = ++count <= max_count ? "Y" : "N";
                if (!state.equals(row.get((Object)"fstate"))) {
                    batch.add(D.asList((Object[])new Object[]{state, D.l((Object)row.get((Object)"fid"))}));
                }
                if (count > max_count) continue;
                licensedRes.add(new Pair((Object)D.l((Object)row.get((Object)"fresource_id")), (Object)IscResourceLicenseUtil.getEntity(row)));
            }
            if (!batch.isEmpty()) {
                String sql2 = "UPDATE t_isc_lic_resource SET fstate=? WHERE fid=?";
                DbUtil.executeBatch((Connection)cn, (String)sql2, batch, (List)D.asList((Object[])new Integer[]{12, -5}));
            }
            HashSet<Pair> hashSet = licensedRes;
            return hashSet;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static String getEntity(DataRow row) {
        String type = D.s((Object)row.get((Object)"ftype"));
        int i = type.indexOf(46);
        if (i > 0) {
            type = type.substring(0, i);
        }
        return type;
    }

    public static void clearCache() {
        String accountId = RequestContext.get().getAccountId();
        cache.remove(accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)IscResourceLicenseUtil.class.getName(), (String)"mqClearCache", (Object[])new Object[]{accountId});
        IscResourceLicenseUtil.getLicensedRes();
    }

    public static void mqClearCache(String accountId) {
        cache.remove(accountId);
        IscResourceLicenseUtil.getLicensedRes();
    }

    public static boolean hasLicense(String type, long id) {
        Pair key;
        Set<Pair<Long, String>> licensedRes = IscResourceLicenseUtil.getLicensedRes();
        if (!licensedRes.contains(key = new Pair((Object)id, (Object)type))) {
            return false;
        }
        return !LicenseCache.getTenant().isExpired();
    }

    public static int usedLicenseCount() {
        Set<Pair<Long, String>> licensedRes = IscResourceLicenseUtil.getLicensedRes();
        return licensedRes.size();
    }

    private static Set<Pair<Long, String>> getLicensedRes() {
        String accountId = RequestContext.get().getAccountId();
        Set<Pair<Long, String>> licensedRes = cache.get(accountId);
        if (licensedRes == null) {
            licensedRes = IscResourceLicenseUtil.syncLicenseState();
            cache.put(accountId, licensedRes);
        }
        return licensedRes;
    }
}

