/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

class IscWhiteListItem
implements ObjectSizeIgnored {
    private long id;
    private String type;
    private long pk;
    private String hash;
    private String state;
    private String sign;
    private volatile Boolean valid;

    private IscWhiteListItem(DynamicObject cfg) {
        this.hash = cfg.getString("hash");
        this.sign = cfg.getString("sign");
        this.type = cfg.getString("type");
        this.pk = D.l((Object)cfg.getString("spk"));
        this.state = cfg.getString("state");
        this.id = cfg.getLong("id");
    }

    boolean isValid() {
        return this.isValid(null);
    }

    boolean isValid(DynamicObject res) {
        Boolean valid = this.valid;
        if (valid != null) {
            return valid;
        }
        String state = IscWhiteListUtil.getState(this.type, this.pk, this.hash, this.sign, res);
        if (!state.equals(this.state)) {
            LightTaskManager.submit(this.createTaskForUpdateState(state));
        }
        valid = this.valid = Boolean.valueOf(IscWhiteListUtil.isValid(state));
        return this.valid;
    }

    private LightTask createTaskForUpdateState(final String state) {
        return new LightTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public void run() {
                IscWhiteListUtil.updateState(IscWhiteListItem.this.id, state);
            }

            @Override
            public String getId() {
                return this.id;
            }
        };
    }

    static IscWhiteListItem get(String type, long id) {
        QFilter filter = new QFilter("spk", "=", (Object)String.valueOf(id)).and(new QFilter("type", "=", (Object)type));
        return CacheableObjectManager.getByFilter(IscWhiteListItem.class, filter);
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<IscWhiteListItem>(){

            @Override
            public String entityType() {
                return "isc_white_list";
            }

            @Override
            public IscWhiteListItem create(DynamicObject cfg) {
                return new IscWhiteListItem(cfg);
            }

            @Override
            public Class<IscWhiteListItem> target() {
                return IscWhiteListItem.class;
            }
        });
    }
}

