/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.isc.iscb.platform.core.license.IscWhiteListState;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.Rsa;
import kd.isc.iscb.util.script.encoding.Murmur;

public class IscWhiteListUtil {
    public static final String pk = "8279870512416623814331406854743365863417800100708630777184060680516456074384236519194164444309831899126368055389363566528516619305791116595413197898720351,65537";
    private static DataFlowInfoGetter DFG;

    public static String getState(String type, long id, String hash, String sign, DynamicObject res) {
        Map<String, String> item;
        int i;
        String licenseGroups = null;
        int j = sign.indexOf(59);
        if (j < 0) {
            if (!hash.equals(Rsa.decrypt((String)sign, (String)pk))) {
                return IscWhiteListState.INVALID.name();
            }
        } else {
            licenseGroups = sign.substring(j + 1);
            sign = sign.substring(0, j);
            String hash0 = Hash.mur32((Object[])new Object[]{hash, licenseGroups});
            if (!hash0.equals(Rsa.decrypt((String)sign, (String)pk))) {
                return IscWhiteListState.INVALID.name();
            }
        }
        if (res == null) {
            if (!QueryServiceHelper.exists((String)type, (Object)id)) {
                return IscWhiteListState.UNDEPLOYED.name();
            }
            res = BusinessDataServiceHelper.loadSingle((Object)id, (String)type);
        }
        if ((i = hash.indexOf(47)) > 0) {
            licenseGroups = hash.substring(i + 1);
            hash = hash.substring(0, i);
        }
        if (!hash.equals((item = IscWhiteListUtil.getWhiteListInfo(res)).get("fhash"))) {
            return IscWhiteListState.CORRUPT.name();
        }
        if (licenseGroups == null) {
            return IscWhiteListState.NORMAL.name();
        }
        for (String licenseGroup : licenseGroups.split(",")) {
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)licenseGroup.trim());
            if (!result.getHasLicense().booleanValue()) continue;
            return IscWhiteListState.NORMAL.name();
        }
        return IscWhiteListState.WITHOUT_BIZ_LIC.name();
    }

    public static boolean isValid(String state) {
        return IscWhiteListState.NORMAL.name().equals(state);
    }

    public static boolean isBuildWhitelistType(String type) {
        switch (type) {
            case "isc_apic_script": 
            case "isc_service_flow": 
            case "isc_data_copy": 
            case "isc_apic_for_external_api": 
            case "isc_metadata_schema": 
            case "isc_apic_webapi": 
            case "iscx_resource": {
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> getWhiteListInfo(DynamicObject o) {
        String entity;
        switch (entity = o.getDataEntityType().getName()) {
            case "isc_apic_script": {
                return IscWhiteListUtil.getScriptApiWhiteListInfo(o);
            }
            case "isc_service_flow": {
                return IscWhiteListUtil.getServiceFlowWhiteListInfo(o);
            }
            case "isc_data_copy": {
                return IscWhiteListUtil.getDataCopySchemaWhiteListInfo(o);
            }
            case "isc_apic_for_external_api": {
                return IscWhiteListUtil.getExternalApiWhiteListInfo(o);
            }
            case "isc_metadata_schema": {
                return IscWhiteListUtil.getMetadataSchemaWhiteListInfo(o);
            }
            case "isc_apic_webapi": {
                return IscWhiteListUtil.getWebapiWhiteListInfo(o);
            }
            case "iscx_resource": {
                return IscWhiteListUtil.getDataFlowWhiteListInfo(o);
            }
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8d44\u6e90\u7c7b\u578b\uff1a%s", (String)"IscWhiteListUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
    }

    private static Map<String, String> getScriptApiWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        IscWhiteListUtil.getResources(o, feature, description);
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getServiceFlowWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        feature.append('\uff0c').append(o.get("init_mode"));
        description.append(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\uff1a", (String)"IscWhiteListUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(o.get("init_mode"));
        IscWhiteListUtil.getResources(o, feature, description);
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getDataFlowWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        StringBuilder description = new StringBuilder();
        DFG.collect(o, feature, description);
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getDataCopySchemaWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        feature.append('\uff0c').append(o.get("source_schema_id"));
        description.append(String.format(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\uff1a%1$s\uff0c\u76ee\u6807\u5bf9\u8c61\uff1a%2$s", (String)"IscWhiteListUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), IscWhiteListUtil.getResourceName(o, "source_schema"), IscWhiteListUtil.getResourceName(o, "target_schema")));
        feature.append('\uff0c').append(o.get("target_schema_id"));
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getExternalApiWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        feature.append('\uff0c').append(o.get("group_id"));
        feature.append('\uff0c').append(o.get("service"));
        description.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff1a%1$s\uff0c\u63a5\u53e3\u6807\u8bc6\uff1a%2$s", (String)"IscWhiteListUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), IscWhiteListUtil.getResourceName(o, "group"), o.get("service")));
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getMetadataSchemaWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        feature.append('\uff0c').append(o.get("group_id"));
        description.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff1a%1$s\uff0c\u5168\u540d\uff1a%2$s", (String)"IscWhiteListUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), IscWhiteListUtil.getResourceName(o, "group"), o.get("full_name")));
        feature.append('\uff0c').append(o.get("full_name"));
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static Map<String, String> getWebapiWhiteListInfo(DynamicObject o) {
        StringBuilder feature = new StringBuilder();
        StringBuilder description = new StringBuilder();
        Map<String, String> item = IscWhiteListUtil.getBasics(o, feature);
        feature.append('\uff0c').append(o.get("group_id"));
        description.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff1a%1$s\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a%2$s\uff0cURL\u524d\u7f00\uff1a%3$s\uff0cURL\u8def\u5f84\uff1a%4$s\u3002", (String)"IscWhiteListUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), IscWhiteListUtil.getResourceName(o, "group"), o.get("method"), o.get("url_prefix"), o.get("url_path")));
        feature.append('\uff0c').append(o.get("method"));
        feature.append('\uff0c').append(o.get("url_prefix"));
        feature.append('\uff0c').append(o.get("url_path"));
        item.put("fdescription", description.toString());
        IscWhiteListUtil.setFeatureHash(item, feature);
        return item;
    }

    private static void getResources(DynamicObject o, StringBuilder feature, StringBuilder description) {
        feature.append('\uff1b');
        description.append(ResManager.loadKDString((String)"\uff1b\u4f9d\u8d56\uff1a", (String)"IscWhiteListUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        boolean noRes = true;
        for (DynamicObject resRefItem : (DynamicObjectCollection)o.get("resources")) {
            DynamicObject res = (DynamicObject)resRefItem.get("res_ref");
            if (res == null) continue;
            noRes = false;
            feature.append(res.get("id")).append(',');
            description.append(IscWhiteListUtil.getName(res)).append("; ");
        }
        if (noRes) {
            description.append('\u65e0');
        }
    }

    private static void setFeatureHash(Map<String, String> item, StringBuilder feature) {
        item.put("fhash", Murmur.calc32((Object[])new Object[]{feature}).toUpperCase(Locale.ENGLISH));
    }

    private static Map<String, String> getBasics(DynamicObject o, StringBuilder feature) {
        LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
        String type = o.getDataEntityType().getName();
        Object id = o.get("id");
        byte[] bytes = (id + ", " + type).getBytes(D.UTF_8);
        item.put("fid", String.valueOf(Math.abs(Murmur.calc((byte[])bytes))));
        item.put("ftype", type);
        feature.append(type);
        item.put("fspk", String.valueOf(id));
        feature.append('\uff0c').append(id);
        item.put("fnumber", o.getString("number"));
        feature.append('\uff0c').append(o.getString("number"));
        item.put("fname", IscWhiteListUtil.getName(o));
        feature.append('\uff0c').append(IscWhiteListUtil.getName(o));
        return item;
    }

    private static String getName(DynamicObject o) {
        Object name = o.get("name");
        if (name instanceof ILocaleString) {
            ILocaleString ls = (ILocaleString)name;
            String s = D.s((Object)ls.getLocaleValue_zh_CN());
            if (s != null) {
                return s;
            }
            s = D.s((Object)ls.getLocaleValue_zh_TW());
            if (s != null) {
                return s;
            }
            s = D.s((Object)ls.getLocaleValue_en());
            if (s != null) {
                return s;
            }
            return D.s((Object)ls.get((Object)"GLang"));
        }
        return D.s((Object)name);
    }

    private static String getResourceName(DynamicObject o, String field) {
        DynamicObject ref = (DynamicObject)o.get(field);
        if (ref == null) {
            return null;
        }
        return IscWhiteListUtil.getName(ref);
    }

    public static boolean refreshState(Object ... ids) {
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"isc_white_list");
        DynamicObject[] list = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)entity);
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (DynamicObject o : list) {
            String sign;
            String hash;
            long id;
            String type = o.getString("type");
            String state = IscWhiteListUtil.getState(type, id = D.l((Object)o.getString("spk")), hash = o.getString("hash"), sign = o.getString("sign"), null);
            if (state.equals(o.getString("state"))) continue;
            batch.add(Arrays.asList(state, o.get("id")));
        }
        if (batch.isEmpty()) {
            return false;
        }
        IscWhiteListUtil.updateState(batch);
        return true;
    }

    static void updateState(long id, String state) {
        List<Object> params = Arrays.asList(state, id);
        IscWhiteListUtil.updateState(Collections.singletonList(params));
    }

    private static void updateState(List<List<Object>> batch) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "UPDATE T_ISC_WHITE_LIST SET fstate=? WHERE fid=?";
            DbUtil.executeBatch((Connection)cn, (String)sql, batch, Arrays.asList(12, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static boolean importPreCheckData(Map<String, Object> map) {
        IscWhiteListUtil.refreshState(D.l((Object)map.get("id")));
        QFilter filter = new QFilter("id", "=", (Object)D.l((Object)map.get("id")));
        DynamicObject white = QueryServiceHelper.queryOne((String)"isc_white_list", (String)"state", (QFilter[])new QFilter[]{filter});
        if (white != null && IscWhiteListUtil.isValid(white.getString("state"))) {
            return false;
        }
        IscWhiteListUtil.importPreHandleData(map);
        return true;
    }

    public static void importPreHandleData(Map<String, Object> map) {
        map.put("$id", D.l((Object)map.get("id")));
        map.put("$entityname", "isc_white_list");
        map.put("$isref", Boolean.FALSE);
        map.put("state", Character.valueOf(' '));
    }

    static {
        try {
            DFG = (DataFlowInfoGetter)ReflectionUtil.newInstance((String)"kd.isc.iscx.platform.core.res.runtime.util.DataFlowInfoGetterImpl");
        }
        catch (Throwable e) {
            DFG = new DataFlowInfoGetter(){

                @Override
                public void collect(DynamicObject res, StringBuilder feature, StringBuilder description) {
                    throw new IscBizException("ISCX not deployed.", e);
                }
            };
        }
    }

    public static interface DataFlowInfoGetter {
        public void collect(DynamicObject var1, StringBuilder var2, StringBuilder var3);
    }
}

