/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.license.UpdateCloudWhiteListJobFactory;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class UpdateCloudWhiteListJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(UpdateCloudWhiteListJob.class);
    public static final UpdateCloudWhiteListJobFactory FACTORY = new UpdateCloudWhiteListJobFactory();
    private final String param;
    private final String title;
    private final int total = 10000;
    private final AtomicInteger success = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private final AtomicInteger omitted = new AtomicInteger(0);
    private String current;
    private List<String> resourceIdList;

    public UpdateCloudWhiteListJob(String title, String param) {
        this.title = title;
        this.param = param;
        Map paramMap = (Map)Json.toObject((String)param);
        this.resourceIdList = (List)paramMap.get("resourceIdList");
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.current;
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"UpdateCloudWhiteListJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.success.get() + this.failed.get() + this.omitted.get();
        return new Job.Progress(10000L, completed, this.current);
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        int total = this.success.get() + this.failed.get() + this.omitted.get();
        sb.append(ResManager.loadKDString((String)"\u4e91\u73af\u5883\u767d\u540d\u5355\u603b\u6570\uff1a", (String)"UpdateCloudWhiteListJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(total).append('\uff1b');
        sb.append('\n').append(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u66f4\u65b0\u6210\u529f\uff1a", (String)"UpdateCloudWhiteListJob_8", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.success).append('\uff1b');
        if (this.omitted.get() > 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\n\u5ffd\u7565\uff1a%s\uff0c\u5ffd\u7565\u539f\u56e0\uff1a\u6b64\u767d\u540d\u5355\u5728\u5f53\u524d\u73af\u5883\u4e2d\u8bb8\u53ef\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u65e0\u9700\u5bfc\u5165\uff1b", (String)"UpdateCloudWhiteListJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted));
        }
        if (this.failed.get() > 0) {
            sb.append('\n').append(ResManager.loadKDString((String)"\u5931\u8d25\uff1a", (String)"UpdateCloudWhiteListJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.failed);
        }
        return sb.toString();
    }

    @Override
    public void run() {
        String queryUrl = "kapi/v2/kdec/iscb/isc_white_list/query_white_list";
        if (this.resourceIdList != null && !this.resourceIdList.isEmpty()) {
            int count = 0;
            StringBuilder sb = new StringBuilder();
            for (String resId : this.resourceIdList) {
                sb.append("id=").append(resId).append('&');
                if (++count != 20) continue;
                String requestUrl = queryUrl + "?" + sb.substring(0, sb.length() - 1);
                this.queryWhiteListAndsave(requestUrl);
                count = 0;
                sb = new StringBuilder();
            }
            if (count > 0) {
                String requestUrl = queryUrl + "?" + sb.substring(0, sb.length() - 1);
                this.queryWhiteListAndsave(requestUrl);
            }
        } else {
            this.queryWhiteListAndsave(queryUrl);
        }
        CacheableObjectManager.clearCache();
    }

    private void queryWhiteListAndsave(String url) {
        int pageNo = 0;
        List<Map<String, Object>> whiteList = UpdateCloudWhiteListJob.queryWhiteListByPage(url, ++pageNo);
        while (whiteList.size() != 0) {
            this.saveWhiteList(whiteList);
            whiteList = UpdateCloudWhiteListJob.queryWhiteListByPage(url, ++pageNo);
        }
    }

    private void saveWhiteList(List<Map<String, Object>> whiteList) {
        for (Map<String, Object> white : whiteList) {
            Object name = white.get("name");
            this.current = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u66f4\u65b0\uff1a\u767d\u540d\u5355\uff08%s)", (String)"UpdateCloudWhiteListJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name);
            try {
                if (IscWhiteListUtil.importPreCheckData(white)) {
                    ImportDynamicObject.innerImport(Json.toString(white));
                    this.success.incrementAndGet();
                    continue;
                }
                this.omitted.incrementAndGet();
            }
            catch (Exception e) {
                this.failed.incrementAndGet();
                LOGGER.error("UpdateCloudWhiteListJob,\u66f4\u65b0\u4e91\u7aef\u767d\u540d\u5355[" + name + "]\u5931\u8d25\u3002" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            }
        }
    }

    private static List<Map<String, Object>> queryWhiteListByPage(String api, int pageNo) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("pageSize", PublicResourceUtil.DEFAULT_PAGE_SIZE);
        param.put("pageNo", pageNo);
        List<Map<String, Object>> whiteList = PublicResourceUtil.queryListByGet(api, param);
        return whiteList;
    }
}

