/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.ischub.job.EventLogCleaner;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.util.misc.StringUtil;

public enum GroupCategory {
    BIZ_WEBAPI{
        private final Log logger = LogFactory.getLog(EventLogCleaner.class);

        @Override
        public boolean isFree(String connectionType) {
            if (connectionType.startsWith("SCM-")) {
                return this.iscFreeLicense(connectionType) || this.checkMalEcLicense(connectionType);
            }
            return this.iscFreeLicense(connectionType);
        }

        private boolean iscFreeLicense(String connectionType) {
            return "CloudHub".equals(connectionType) || "SCM-JD".equals(connectionType) || "SCM-SN".equals(connectionType) || "SCM-XY".equals(connectionType) || "SCM-CG".equals(connectionType) || "SCM-DL".equals(connectionType) || "TMS_KD100".equals(connectionType) || "TAXC-ZWY".equals(connectionType) || "TAXC-GZTAX".equals(connectionType) || "SCM-JDPRO".equals(connectionType) || "SCM-XFS".equals(connectionType);
        }

        private boolean checkMalEcLicense(String connectionType) {
            try {
                return (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalLicenseCheckService", (String)"checkMalEcLicense", (Object[])new Object[]{connectionType});
            }
            catch (Exception e) {
                this.logger.warn("isc_get_malEcLicense_failed\uff0c\u8fde\u63a5\u7c7b\u578b\u3010" + connectionType + "\u3011\uff0c\u8c03\u7528SCM\u83b7\u53d6\u8bb8\u53ef\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
                return false;
            }
        }

        @Override
        public int maxLicenseBudgetCount(GroupInfo group) {
            if (group.getAccount().getTenant().isNewLicense()) {
                return Integer.MAX_VALUE;
            }
            return 1;
        }

        @Override
        public boolean isMQ() {
            return false;
        }
    }
    ,
    BIZ_DEDICATED{

        @Override
        public boolean isFree(String connectionType) {
            return "self".equals(connectionType) || "DummyConnector".equals(connectionType) || "isc_hub".equals(connectionType) || "KDB".equals(connectionType) || "CurrentDB".equals(connectionType);
        }

        @Override
        public int maxLicenseBudgetCount(GroupInfo group) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isMQ() {
            return false;
        }
    }
    ,
    BIZ_OTHER{

        @Override
        public boolean isFree(String connectionType) {
            return false;
        }

        @Override
        public int maxLicenseBudgetCount(GroupInfo group) {
            if (group.getAccount().getTenant().isNewLicense()) {
                return Integer.MAX_VALUE;
            }
            return 1;
        }

        @Override
        public boolean isMQ() {
            return false;
        }
    }
    ,
    MQ_SERVER{

        @Override
        public boolean isFree(String connectionType) {
            return "InternalRabbit".equals(connectionType);
        }

        @Override
        public int maxLicenseBudgetCount(GroupInfo group) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isMQ() {
            return true;
        }
    };


    public abstract boolean isMQ();

    public abstract boolean isFree(String var1);

    public abstract int maxLicenseBudgetCount(GroupInfo var1);

    public static GroupCategory getCategory(String connectionType, boolean isMQ, String account) {
        if (isMQ) {
            return MQ_SERVER;
        }
        return GroupCategory.getBizSystemCategory(connectionType, account);
    }

    private static GroupCategory getBizSystemCategory(String connectionType, String account) {
        ConnectionFactory factory = DatabaseType.find(connectionType, account);
        if (factory == null) {
            return BIZ_OTHER;
        }
        String factoryPackage = factory.getClass().getPackage().getName();
        if (factory.getClass() == WebApiConnectionFactory.class) {
            return BIZ_WEBAPI;
        }
        if (factoryPackage.startsWith(ConnectionFactory.class.getPackage().getName())) {
            return BIZ_DEDICATED;
        }
        return BIZ_OTHER;
    }
}

