/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class MCLicenseUtil {
    private static final Log logger = LogFactory.getLog(MCLicenseUtil.class);
    private static final String LICENSE_SUFFIX = "/kapi/app/mc/getlicensebytenantid";
    private static final String PRODUCT_VERSION = "productVersion";
    private static final String EXPIRE_DATE = "expireDate";
    private static final String MODULE_DETAILS = "moduleDetails";
    private static final String CONTENT = "content";

    public static Map<String, Object> getProductInfo() {
        try {
            return MCLicenseUtil.innerGetProductInfo();
        }
        catch (Throwable e) {
            logger.warn("\u4eceMC\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u8bb8\u53ef\u4fe1\u606f\u5931\u8d25\u3002", e);
            return new HashMap<String, Object>();
        }
    }

    private static Map<String, Object> innerGetProductInfo() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        String tenantId = RequestContext.get().getTenantId();
        params.put("tenantId", tenantId);
        List<Map<String, Object>> dataList = MCLicenseUtil.getLicenseInfo(params, tenantId);
        for (Map<String, Object> item : dataList) {
            Map<String, Object> content;
            if (!tenantId.equals(item.get("tenantId")) || CollectionUtils.isEmpty(content = MCLicenseUtil.getIscProductInfo(item))) continue;
            return content;
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> getIscProductInfo(Map<String, Object> item) {
        Map content = (Map)item.get(CONTENT);
        Object module_details = content.get(MODULE_DETAILS);
        if (module_details != null) {
            List moduleDetails = (List)module_details;
            for (Map module : moduleDetails) {
                if (!"PRO_ISC".equals(module.get("moduleName"))) continue;
                HashMap logMap = new HashMap(6);
                logMap.put("moduleAlias", module.get("moduleAlias"));
                logMap.put("licenseNum", module.get("licenseNum"));
                logMap.put("moduleName", module.get("moduleName"));
                logMap.put("groupName", module.get("groupName"));
                logMap.put("beginDate", module.get("beginDate"));
                logMap.put("endDate", module.get("endDate"));
                logger.info("\u4eceMC\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u96c6\u6210\u4e91\u8bb8\u53ef\u4fe1\u606f\uff1a" + Json.toString(logMap, (boolean)true));
                return content;
            }
        }
        logger.info("\u4eceMC\u63a5\u53e3\u6ca1\u6709\u83b7\u53d6\u5230moduleName\u4e3aPRO_ISC\u7684\u96c6\u6210\u4e91\u8bb8\u53ef\u4fe1\u606f");
        return Collections.emptyMap();
    }

    public static int getLicenseNum(Map<String, Object> productInfo) {
        try {
            return MCLicenseUtil.innerGetLicenseNum(productInfo);
        }
        catch (Throwable e) {
            logger.warn("\u4eceMC\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u8bb8\u53ef\u4fe1\u606f\u5931\u8d25\u3002", e);
            return -3;
        }
    }

    public static String getExpireDate(Map<String, Object> productInfo) {
        return D.s((Object)productInfo.get(EXPIRE_DATE));
    }

    private static int innerGetLicenseNum(Map<String, Object> content) {
        if ("1.0".equals(content.get(PRODUCT_VERSION))) {
            return -2;
        }
        int licenseNum = -1;
        Object module_details = content.get(MODULE_DETAILS);
        if (module_details != null) {
            List moduleDetails = (List)module_details;
            for (Map module : moduleDetails) {
                if (!"PRO_ISC".equals(module.get("moduleName"))) continue;
                licenseNum = D.i(module.get("licenseNum"));
                break;
            }
        }
        return licenseNum;
    }

    private static List<Map<String, Object>> getLicenseInfo(Map<Object, Object> params, String tenantId) {
        String url = System.getProperty("mc.server.url");
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Object result = NetUtil.httpInvoke((String)(url + LICENSE_SUFFIX), params);
        Object data = ((Map)result).get("data");
        if (data == null || ((List)data).isEmpty()) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6839\u636e%1$s\u4ece%2$s\u4e2d\u83b7\u53d6\u7684data\u4e3a\u7a7a\u3002", (String)"MCLicenseUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tenantId, url));
        }
        List dataList = (List)data;
        MCLicenseUtil.removeSensitiveInfo(dataList);
        return dataList;
    }

    private static void removeSensitiveInfo(List<Map<String, Object>> dataList) {
        for (Map<String, Object> map : dataList) {
            Map content = (Map)map.get(CONTENT);
            HashMap remainContent = new HashMap(4);
            remainContent.put(PRODUCT_VERSION, content.get(PRODUCT_VERSION));
            remainContent.put(EXPIRE_DATE, content.get(EXPIRE_DATE));
            remainContent.put(MODULE_DETAILS, content.get(MODULE_DETAILS));
            map.put(CONTENT, remainContent);
        }
    }
}

