/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.LicenseKey;
import kd.isc.iscb.platform.core.license.n.LicenseTask;
import kd.isc.iscb.util.dt.D;

public class TenantInfo {
    private LicenseKey key;
    private String groupNumber;
    private MultiLangEnumBridge groupName;
    private MultiLangEnumBridge calcType;
    private String fileType;
    private MultiLangEnumBridge region;
    private String expiredDate;
    private String licenseVersion;
    private int licenseMainVersion;
    private int totalLicenseCount;
    private int usedLicenseCount;
    private int unusedLicenseCount;
    private long deadline;
    private boolean iscx_enabled;
    private int resourceLicenseCount;
    private boolean iscb_enabled;
    private int mode;
    private Map<String, AccountInfo> accounts = new LinkedHashMap<String, AccountInfo>();
    private static final Timestamp START_TIME = new Timestamp(System.currentTimeMillis());

    TenantInfo(LicenseTask task) {
        this.key = task.getKey();
        this.groupNumber = "PRO_ISC";
        this.groupName = new MultiLangEnumBridge("\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4", "TenantInfo_0", "isc-iscb-platform-core");
        this.calcType = new MultiLangEnumBridge("\u7279\u6027", "TenantInfo_1", "isc-iscb-platform-core");
        this.expiredDate = task.getExpiredDate();
        this.deadline = D.t((Object)this.expiredDate).getTime() + 777600000L - 1L;
        this.fileType = task.getFileType();
        this.region = new MultiLangEnumBridge("\u96c6\u6210\u670d\u52a1\u4e91", "TenantInfo_2", "isc-iscb-platform-core");
        this.licenseVersion = task.getVersion();
        this.iscx_enabled = task.iscxEnabled();
        this.iscb_enabled = task.iscbEnabled();
        this.mode = task.getLicenseMode();
        this.resourceLicenseCount = task.getResourceLicenseCount();
        try {
            this.licenseMainVersion = D.n((Object)this.licenseVersion).intValue();
        }
        catch (Exception e) {
            this.licenseMainVersion = 3;
        }
        this.totalLicenseCount = this.unusedLicenseCount = task.getLicenseCount();
        this.usedLicenseCount = 0;
    }

    public boolean iscxEnabled() {
        return this.iscx_enabled;
    }

    public boolean iscbEnabled() {
        return this.iscb_enabled;
    }

    public int getLicenseMode() {
        return this.mode;
    }

    public int getLicenseMainVersion() {
        return this.licenseMainVersion;
    }

    public boolean isLicenseValid() {
        return System.currentTimeMillis() <= this.deadline;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.deadline;
    }

    int deductLicense() {
        if (this.unusedLicenseCount == 0) {
            return -1;
        }
        --this.unusedLicenseCount;
        return ++this.usedLicenseCount;
    }

    AccountInfo getOrCreateAccount(String accountId, String accountName) {
        AccountInfo account = this.accounts.get(accountId);
        if (account == null) {
            account = new AccountInfo(this, accountId, accountName);
            this.accounts.put(accountId, account);
        }
        return account;
    }

    public AccountInfo getAccount(String accountId) {
        return this.accounts.get(accountId);
    }

    public AccountInfo getCurrentAccount() {
        String accountId = RequestContext.get().getAccountId();
        return this.getAccount(accountId);
    }

    public LicenseKey getKey() {
        return this.key;
    }

    public String getId() {
        return this.key.getTenantId();
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public String getGroupName() {
        return this.groupName.loadKDString();
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getCalcType() {
        return this.calcType.loadKDString();
    }

    public String getRegion() {
        return this.region.loadKDString();
    }

    public long getDeadline() {
        return this.deadline;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public int getTotalLicenseCount() {
        return this.totalLicenseCount;
    }

    public int getUsedLicenseCount() {
        return this.usedLicenseCount;
    }

    public int getUnusedLicenseCount() {
        return this.unusedLicenseCount;
    }

    public Map<String, AccountInfo> getAccounts() {
        return Collections.unmodifiableMap(this.accounts);
    }

    public boolean isNewLicense() {
        return this.licenseMainVersion > 3;
    }

    public boolean hasValidLicense() {
        return this.getTotalLicenseCount() > 0 && !this.isExpired();
    }

    public int getResourceLicenseCount() {
        return this.resourceLicenseCount;
    }

    public Timestamp getStartTime() {
        return START_TIME;
    }
}

