/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log;

import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.log.CountFailedEventJobFactory;
import kd.isc.iscb.platform.core.log.EventFailTotalUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class CountFailedEventJob
implements Job {
    public static final JobFactory FACTORY = new CountFailedEventJobFactory();
    private static Log logger = LogFactory.getLog(CountFailedEventJob.class);
    private static final long id = Math.abs(Hash.mur((Object[])new Object[]{"CountFailedEventJob"}));
    private static final List<Integer> DAYSBEFORE = Arrays.asList(1, 7);
    private String param;
    private String title;

    public static void createCountEventJob() {
        try (DLock lock = DLock.create((String)("/isc/iscb/eventcount/" + id)).fastMode();){
            if (!JobEngine.existsJobWithOwnerId(id) && lock.tryLock()) {
                Timestamp delay = new Timestamp(System.currentTimeMillis() + (long)(300000 + new SecureRandom().nextInt(3000)));
                JobEngine.submit(new CountFailedEventJob(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u4e8b\u4ef6\u7edf\u8ba1\u540e\u53f0\u4efb\u52a1", (String)"CountFailedEventJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s((Object)id)), delay);
            }
        }
    }

    @Override
    public void run() {
        if (JobEngine.isMaster()) {
            try {
                CountFailedEventJob.execute();
            }
            catch (Exception e) {
                logger.warn("\u6267\u884c\u5f02\u6b65\u5237\u65b0\u4e8b\u4ef6\u89e6\u53d1\u5931\u8d25\u6c47\u603b\u4efb\u52a1\u5931\u8d25:", (Throwable)e);
            }
            finally {
                Timestamp nextTime = new Timestamp(System.currentTimeMillis() + 10800000L);
                JobEngine.submit(this, nextTime);
            }
        }
    }

    public static void execute() {
        List<Map<String, Object>> dbLinkList = EventFailTotalUtil.getEventDbLinkList();
        for (Map<String, Object> dbLink : dbLinkList) {
            long linkId = D.l((Object)dbLink.get("fid"));
            String dbType = D.s((Object)dbLink.get("fdatabase_type"));
            CountFailedEventJob.handleEachConnection(linkId, dbType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEachConnection(long linkId, String dbType) {
        ConnectionWrapper cn = null;
        ConnectionManager.pushResLicense(true);
        try {
            String iscHub = EventFailTotalUtil.getIscHub(linkId, dbType);
            cn = ConnectionManager.getConnection(D.l((Object)linkId));
            for (int i = 0; i < DAYSBEFORE.size(); ++i) {
                Integer daysBefore = DAYSBEFORE.get(i);
                int failTotal = EventFailTotalUtil.queryTotal(cn, iscHub, daysBefore);
                EventFailTotalUtil.saveEventLogTotal(linkId, dbType, daysBefore, failTotal);
            }
        }
        catch (Throwable e) {
            try {
                EventFailTotalUtil.saveEventLogFail(linkId, dbType, -1, StringUtil.getCascadeMessage((Throwable)e));
            }
            catch (Throwable throwable) {
                ConnectionManager.popResLicense();
                ConnectorUtil.close(cn);
                throw throwable;
            }
            ConnectionManager.popResLicense();
            ConnectorUtil.close(cn);
        }
        ConnectionManager.popResLicense();
        ConnectorUtil.close(cn);
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public long getOwnerId() {
        return id;
    }

    public CountFailedEventJob(String title, String param) {
        this.title = title;
        this.param = param;
    }
}

