/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class EventFailTotalUtil {
    private static final String EVENT_DBLINK_SQL = "SELECT fid,fdatabase_type FROM T_ISC_DATABASE_LINK WHERE fdatabase_type in ('eas','self','db_proxy','ierp')";
    private static final String COUNT_SQL = "SELECT count(*) as failtotal FROM T_ISCB_CON_EVT_QUE WHERE fstate = ? and fisc_hub = ? and fcreated_time > ?";
    private static final String INSERT_SQL = "INSERT INTO T_ISC_EVENT_STATISTICS (FID, FCREATE_TIME, FMODIFY_TIME, FFAIL_TOTAL, FDATE_RANGE, FDBLINK, FDATABASE_TYPE, FERROR, FERROR_TAG) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_SQL = "UPDATE T_ISC_EVENT_STATISTICS SET FFAIL_TOTAL = ?,FMODIFY_TIME = ?, FERROR = ?, FERROR_TAG = ? WHERE FDBLINK = ? and FDATE_RANGE = ?";
    private static final String TOTAL_SQL = "SELECT sum(FFAIL_TOTAL) as failtotal from T_ISC_EVENT_STATISTICS where FFAIL_TOTAL >0 and FDATE_RANGE = ?";
    private static final String DBLINK_SQL = "SELECT fdatabase_type from T_ISC_DATABASE_LINK where fid = ?";
    private static final String SELF_SQL = "SELECT fdblink from T_ISC_EVENT_STATISTICS where fdatabase_type = 'self'";
    private static final String EXIST_SQL = "SELECT count(*) FROM T_ISC_EVENT_STATISTICS WHERE FDBLINK = ? and FDATE_RANGE = ?";
    private static final List<Integer> DAYSBEFORE = Arrays.asList(1, 7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryTotal(ConnectionWrapper cn, String iscHub, Integer daysBefore) {
        int failTotal;
        ObjectReader<DataRow> reader = null;
        try {
            reader = cn.executeQuery(COUNT_SQL, Arrays.asList("F", iscHub, EventFailTotalUtil.getTimeStampByDaysBefore(daysBefore)), Arrays.asList(12, 12, -5));
            DataRow data = (DataRow)reader.read();
            failTotal = D.i((Object)data.get((Object)"failtotal"));
        }
        finally {
            DbUtil.close(reader);
        }
        return failTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAllEventFailLogTotal(Connection cn, Integer daysBefore) {
        DataRow data;
        ObjectReader reader = null;
        try {
            reader = DbUtil.executeQuery((Connection)cn, (String)TOTAL_SQL, Collections.singletonList(daysBefore), Collections.singletonList(12));
            data = (DataRow)reader.read();
        }
        catch (Throwable throwable) {
            DbUtil.close(reader);
            throw throwable;
        }
        DbUtil.close((ObjectReader)reader);
        return D.l((Object)data.get((Object)"failtotal"));
    }

    public static String getIscHub(long linkId, String dbType) {
        String iscHub = ConnectorUtil.getIscHub(linkId);
        if ("self".equals(dbType)) {
            iscHub = "{self}";
        }
        return iscHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getEventDbLinkList() {
        ArrayList<Map<String, Object>> dbLinkList = new ArrayList<Map<String, Object>>();
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List dataRows = DbUtil.executeList((Connection)cn, (String)EVENT_DBLINK_SQL, Collections.emptyList(), Collections.emptyList());
            for (DataRow dataRow : dataRows) {
                long selfDblink;
                String databaseType = D.s((Object)dataRow.get((Object)"fdatabase_type"));
                long dblinkId = D.l((Object)dataRow.get((Object)"fid"));
                if (StringUtils.equals((CharSequence)"self", (CharSequence)databaseType) && (selfDblink = EventFailTotalUtil.getSelfDblink(dblinkId)) != dblinkId) continue;
                Map item = dataRow.toMap();
                dbLinkList.add(item);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return dbLinkList;
    }

    public static void saveEventLogTotal(long dblink, String dbType, Integer daysBefore, int failtotal) {
        EventFailTotalUtil.saveEventFailLog(dblink, dbType, failtotal, daysBefore, null);
    }

    public static void saveEventLogFail(long dblink, String databaseType, int failtotal, String errorTag) {
        EventFailTotalUtil.saveEventFailLog(dblink, databaseType, failtotal, 1, errorTag);
        EventFailTotalUtil.saveEventFailLog(dblink, databaseType, failtotal, 7, errorTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEventFailLog(long dblink, String databaseType, int failtotal, Integer daysBefore, String errorTag) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        String error = EventFailTotalUtil.getSubError(errorTag);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        try {
            if (EventFailTotalUtil.isExistFailLog(dblink, daysBefore)) {
                DbUtil.executeUpdate((Connection)cn, (String)UPDATE_SQL, Arrays.asList(failtotal, now, error, errorTag, dblink, D.s((Object)daysBefore)), Arrays.asList(4, 93, 12, 12, -5, 12));
            } else {
                String id = D.s((Object)DB.genLongId((String)"T_ISC_EVENT_STATISTICS"));
                List<Object> params = Arrays.asList(id, now, now, failtotal, D.s((Object)daysBefore), dblink, databaseType, error, errorTag);
                List<Integer> types = Arrays.asList(-5, 93, 93, 4, 12, -5, 12, 12, 12);
                DbUtil.executeUpdate((Connection)cn, (String)INSERT_SQL, params, types);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistFailLog(long dblink, Integer daysBefore) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            long count = DbUtil.executeCount((Connection)cn, (String)EXIST_SQL, Arrays.asList(dblink, D.s((Object)daysBefore)), Arrays.asList(-5, 12));
            if (count > 0L) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return false;
    }

    public static void updateEvtLogFail(long dblink) {
        String dbType = EventFailTotalUtil.getDatabaseType(dblink);
        if ("self".equals(dbType)) {
            dblink = EventFailTotalUtil.getSelfDblink(dblink);
        }
        for (Integer daysBefore : DAYSBEFORE) {
            EventFailTotalUtil.updateDblinkEventLogFail(dblink, dbType, daysBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatabaseType(long dblink) {
        String dbType;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)DBLINK_SQL, Collections.singletonList(dblink), Collections.singletonList(-5));
            dbType = D.s((Object)dataRow.get((Object)"fdatabase_type"));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSelfDblink(long dblink) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)SELF_SQL, Collections.emptyList(), Collections.emptyList());
            if (dataRow != null) {
                dblink = D.l((Object)dataRow.get((Object)"fdblink"));
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return dblink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDblinkEventLogFail(long dblink, String dbType, Integer daysBefore) {
        String iscHub = EventFailTotalUtil.getIscHub(dblink, dbType);
        ConnectionWrapper cn = null;
        ObjectReader<DataRow> reader = null;
        ConnectionManager.pushResLicense(true);
        try {
            cn = ConnectionManager.getConnection(D.l((Object)dblink));
            reader = cn.executeQuery(COUNT_SQL, Arrays.asList("F", iscHub, EventFailTotalUtil.getTimeStampByDaysBefore(daysBefore)), Arrays.asList(12, 12, -5));
            DataRow data = (DataRow)reader.read();
            EventFailTotalUtil.saveEventLogTotal(dblink, dbType, daysBefore, D.i((Object)data.getValue("failtotal")));
        }
        catch (Throwable e) {
            EventFailTotalUtil.saveEventLogFail(dblink, dbType, -1, e.getMessage());
        }
        finally {
            ConnectionManager.popResLicense();
            DbUtil.close(reader);
            ConnectorUtil.close(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMaxFailedDblink(String datetype) {
        HashMap<String, String> maxFailedMap = new HashMap<String, String>(2);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "select ti.fdblink,tidll.fname as dbname,ti.ffail_total from t_isc_event_statistics ti left join t_isc_database_link tidl on ti.fdblink = tidl.fid left join t_isc_database_link_l tidll on tidl.fid = tidll.fid where tidll.flocaleid ='zh_CN' and ti.fdate_range = ? order by ti.ffail_total desc";
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(datetype), Collections.singletonList(12));
            if (dataRow != null) {
                maxFailedMap.put("dblink", D.s((Object)dataRow.get((Object)"fdblink")));
                maxFailedMap.put("dbname", D.s((Object)dataRow.get((Object)"dbname")));
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return maxFailedMap;
    }

    private static String getSubError(String errorTag) {
        if (errorTag == null) {
            return "";
        }
        if (errorTag.length() > 100) {
            return errorTag.substring(0, 100);
        }
        return errorTag;
    }

    public static long getTimeStampByDaysBefore(Integer daysBefore) {
        long defaultTime = System.currentTimeMillis() - 129600000L;
        if (daysBefore == 7) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -6);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar.getTimeInMillis();
        }
        return defaultTime;
    }
}

