/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.log.es.LogHandler;
import kd.isc.iscb.platform.core.log.es.ProcInstHandler;
import kd.isc.iscb.platform.core.log.es.RecordDependencySwith;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class EsLogUtil {
    private static Log logger = LogFactory.getLog(EsLogUtil.class);
    private static final String ISC_SF_PROC_INST = "isc_sf_proc_inst";
    private static final Map<String, LogHandler> metaToLogHandlerMap = new HashMap<String, LogHandler>();
    private static long MAX_ES_BATCH_SIZE;

    public static long getMaxEsBatchSize() {
        return MAX_ES_BATCH_SIZE;
    }

    public static void saveLogToEs(DynamicObject log) {
        String entityName = log.getDataEntityType().getName();
        LogHandler logHandler = EsLogUtil.getHandlerByEntity(entityName);
        logHandler.save(log);
    }

    public static void migrateDynamicObjToEs(String entityName, List<Object> ids) {
        LogHandler logHandler = metaToLogHandlerMap.get(entityName);
        if (logHandler != null) {
            logHandler.migrateDynamicObjToEs(ids);
        }
    }

    public static LogHandler getHandlerByEntity(String entity) {
        LogHandler logHandler = metaToLogHandlerMap.get(entity);
        if (logHandler == null) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301ES\u5b58\u53d6\u7684\u5355\u636e\u7c7b\u578b\uff1a%s", (String)"EsLogUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        return logHandler;
    }

    public static boolean hasDependency(String srcMeta, String tarMeta) {
        LogHandler logHandler = metaToLogHandlerMap.get(srcMeta);
        if (logHandler != null) {
            List<String> dependMetas = logHandler.getDependMetas();
            if (!CollectionUtils.isEmpty(dependMetas)) {
                return dependMetas.contains(tarMeta);
            }
            return false;
        }
        return false;
    }

    public static boolean isElasticEnabled() {
        boolean isMCEsEnabled = EsLogUtil.isMCEsEnabled();
        boolean isIscEsEnabled = EsLogUtil.isIscEsLogEnabled();
        logger.info("MC es\u914d\u7f6e\u5f00\u5173\uff1a" + isMCEsEnabled + "\uff0c\u96c6\u6210\u4e91es\u914d\u7f6e\u5f00\u5173\uff1a" + isIscEsEnabled);
        return isMCEsEnabled && isIscEsEnabled;
    }

    public static boolean shouldSaveLogToEs() {
        return D.x((Object)System.getProperty(RequestContext.get().getTenantId() + "_saveLogToEs")) && EsLogUtil.isMCEsEnabled();
    }

    public static boolean isMCEsEnabled() {
        RequestContext ctx = RequestContext.get();
        boolean isMCEsEnabled = MCApi.create().enableElastic(ctx.getTenantId(), ctx.getAccountId());
        logger.info("MC es\u914d\u7f6e\u5f00\u5173\uff1a" + isMCEsEnabled);
        return isMCEsEnabled;
    }

    private static boolean isIscEsLogEnabled() {
        try {
            Object enableIscEs = AppParameterServiceHelper.getParameterFromCache("enable_isc_es");
            logger.info("get 'enable_isc_es' parameter,return " + enableIscEs);
            return "true".equals(enableIscEs);
        }
        catch (Exception e) {
            logger.warn("failed to get 'enable_isc_es' parameter.", (Throwable)e);
            return false;
        }
    }

    public static int getDbLogMaxExistedDays() {
        try {
            int maxEsExistDays = D.i((Object)AppParameterServiceHelper.getParameterFromCache("max_db_exist_days"));
            if (maxEsExistDays <= 0 || maxEsExistDays > 7) {
                maxEsExistDays = 7;
            }
            return maxEsExistDays;
        }
        catch (Exception e) {
            logger.warn("failed to get 'getDbLogMaxExistedDays' parameter.", (Throwable)e);
            return 7;
        }
    }

    public static DynamicObject queryIDAndType(Object pkValue) {
        QFilter qFilter = new QFilter("id", "=", pkValue);
        DynamicObjectCollection collection = LogORM.create().query("isc_es_log_item", "billid,billtype", new QFilter[]{qFilter}, 1, 0);
        if (collection.size() > 0) {
            return (DynamicObject)collection.get(0);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"es\u4e2d\u627e\u4e0d\u5230id\u4e3a[%s]\u7684\u65e5\u5fd7\u8bb0\u5f55", (String)"EsLogUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pkValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertObjAndSave(String billType, long billId) {
        LogHandler logHandler = EsLogUtil.getHandlerByEntity(billType);
        try {
            RecordDependencySwith.openRecordDependObjs();
            EsLogUtil.innerRevert(billId, logHandler);
        }
        finally {
            RecordDependencySwith.closeRecordDependObjs();
        }
    }

    private static void innerRevert(long billId, LogHandler logHandler) {
        DynamicObject mainObj = logHandler.revertToLogObj(billId);
        LinkedList<DynamicObject> list = RecordDependencySwith.getDependObjs();
        list.addLast(mainObj);
        try (TXHandle handler = TX.requiresNew();){
            while (list.size() > 0) {
                DynamicObject obj = list.removeFirst();
                ConnectorUtil.save(obj);
                EsLogUtil.updateRevertState(obj.getLong("id"));
            }
            handler.commit();
        }
    }

    public static DynamicObject revertObj(String billType, long billId) {
        LogHandler logHandler = EsLogUtil.getHandlerByEntity(billType);
        try {
            return logHandler.revertToLogObj(billId);
        }
        catch (Throwable e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fd8\u539fES\u4e2did\u4e3a[%1$s]\u7684%2$s\u51fa\u9519,\u539f\u56e0\u662f\uff1a%3$s", (String)"EsLogUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), billId, EntityMetadataCache.getDataEntityType((String)billType).getName(), StringUtil.getCascadeMessage((Throwable)e)), e);
        }
    }

    public static void updateRevertState(long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObjectCollection collection = LogORM.create().query("isc_es_log_item", "id,billtype,opdate,revertstate", new QFilter[]{qFilter}, 1, 0);
        if (collection.size() <= 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"es\u4e2d\u627e\u4e0d\u5230id\u4e3a[%s]\u7684\u65e5\u5fd7\u8bb0\u5f55", (String)"EsLogUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), billId));
        }
        DynamicObject object = (DynamicObject)collection.get(0);
        object.set("revertstate", (Object)"S");
        LogORM.create().update((List)collection);
    }

    static {
        try (InputStream in = EsLogUtil.class.getResourceAsStream("/iscb/loginfos.json");){
            String jsonStr = NetUtil.readText((InputStream)in);
            List logHandlers = (List)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<List<LogHandler>>(){}, (Feature[])new Feature[0]);
            for (LogHandler logHandler : logHandlers) {
                metaToLogHandlerMap.put(logHandler.getMetaNumber(), logHandler);
            }
            metaToLogHandlerMap.put(ISC_SF_PROC_INST, new ProcInstHandler(metaToLogHandlerMap.get(ISC_SF_PROC_INST)));
        }
        catch (Exception e) {
            logger.warn("\u89e3\u6790\u65e5\u5fd7\u4fe1\u606fJSON\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        try {
            MAX_ES_BATCH_SIZE = D.l((Object)System.getProperty("max_es_batch_size", "100000000"));
            if (MAX_ES_BATCH_SIZE <= 0L) {
                MAX_ES_BATCH_SIZE = 100000000L;
            }
        }
        catch (Throwable e) {
            logger.error("\u521d\u59cb\u5316ES\u65e5\u5fd7\u5206\u6279\u5927\u5c0f\u5f02\u5e38\uff1a" + e);
            MAX_ES_BATCH_SIZE = 100000000L;
        }
    }
}

