/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log.es;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.platform.core.log.es.RecordDependencySwith;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class LogBasedataPropSetter
implements Setter {
    private static Log logger = LogFactory.getLog(LogBasedataPropSetter.class);
    private BasedataProp baseData;
    private String entity;
    private boolean isForPreView;

    public LogBasedataPropSetter(String baseDataType, BasedataProp property) {
        this.baseData = property;
        this.entity = baseDataType == null ? this.baseData.getBaseEntityId() : baseDataType;
        if (this.entity == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5b57\u6bb5 %s\u6240\u5173\u8054\u7684\u5b9e\u4f53\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u662f\u5426\u5408\u6cd5\u3002", (String)"LogBasedataPropSetter_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.baseData.getName()));
        }
        this.isForPreView = !RecordDependencySwith.needRecord();
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        if (value == null) {
            object.set(property, null);
        } else if (value instanceof String || value instanceof Number) {
            this.setSingleRef(object, property, value);
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e5\u5fd7\u57fa\u7840\u8d44\u6599\u5c5e\u6027%1$s\u8d4b\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u5b9e\u9645\u7c7b\u578b\uff1a%2$s", (String)"LogBasedataPropSetter_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property, value.getClass().getSimpleName()));
        }
    }

    private void setSingleRef(DynamicObject object, String property, Object id) {
        if (D.s((Object)id) == null) {
            object.set(property, null);
        } else if (id instanceof Number && Long.valueOf(0L).equals(id)) {
            object.set(property, null);
        } else {
            try {
                DynamicObject obj = this.getDynamicObject(object, id);
                object.set(property, (Object)obj);
            }
            catch (Throwable e) {
                if (this.isForPreView) {
                    logger.info("\u9884\u89c8ES\u65e5\u5fd7\uff0c\u627e\u4e0d\u5230F7\u65f6\u4e0d\u5916\u629b\u5f02\u5e38\uff1a", (Object)e);
                    object.set(property, null);
                }
                throw e;
            }
        }
    }

    private DynamicObject getDynamicObject(DynamicObject object, Object id) {
        DynamicObject obj = !QueryServiceHelper.exists((String)this.entity, (Object)id) ? this.queryFromEsIfNeeded(object, id) : BusinessDataServiceHelper.loadSingle((Object)id, (String)this.entity);
        return obj;
    }

    private DynamicObject queryFromEsIfNeeded(DynamicObject object, Object id) {
        DynamicObject obj = null;
        String metaName = object.getDataEntityType().getName();
        if (EsLogUtil.hasDependency(metaName, this.entity)) {
            if (!this.isForPreView) {
                obj = EsLogUtil.revertObj(this.entity, D.l((Object)id));
                RecordDependencySwith.recordDependObjIfNeeded(obj);
            }
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u3010%1$s\uff08%2$s\uff09\u3011\u4e2d\u4e0d\u5b58\u5728ID\u4e3a\uff08%3$s\uff09\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u6216\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"LogBasedataPropSetter_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.baseData.getDisplayName(), this.entity, id));
        }
        return obj;
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        Object val = obj.get(property);
        if (val == null) {
            map.put(property, null);
        } else if (val instanceof DynamicObject) {
            DynamicObject simpleObj = (DynamicObject)val;
            map.put(property, simpleObj.getPkValue());
        } else if (val instanceof Long) {
            map.put(property, Long.valueOf(0L).equals(val) ? null : val);
        } else if (val instanceof String) {
            map.put(property, D.s((Object)val));
        }
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u65e5\u5fd7\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u8bbe\u7f6e\u7c7b\u4e0d\u652f\u6301setSchema\u65b9\u6cd5", (String)"LogBasedataPropSetter_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }
}

