/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.log.ClearLogUtil;
import kd.isc.iscb.platform.core.log.LogEnum;
import kd.isc.iscb.platform.core.log.job.DeleteLogJobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class DeleteLogJob
implements Job {
    public static final JobFactory FACTORY = new DeleteLogJobFactory();
    private AtomicInteger index = new AtomicInteger(0);
    private String params;
    private String title;
    private long counts;
    private IPageCache pageCache;

    public DeleteLogJob(String params, String title) {
        this.params = params;
        this.title = title;
    }

    public DeleteLogJob(String params, String title, IPageCache pageCache) {
        this.params = params;
        this.title = title;
        this.pageCache = pageCache;
    }

    @Override
    public void run() {
        Map map = (Map)Json.toObject((String)this.params);
        List range = (List)map.get("range");
        Map params = (Map)map.get("params");
        boolean isAllState = D.x(map.get("isAllState"));
        this.counts = ClearLogUtil.getAllCounts(this.getLogEnumMap(params), this.getRange(range), isAllState);
        ClearLogUtil.handleDelete(this.getLogEnumMap(params), this.getRange(range), isAllState, this.pageCache, this.index);
    }

    private Map<String, LogEnum> getLogEnumMap(Map<String, String> map) {
        HashMap<String, LogEnum> p = new HashMap<String, LogEnum>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            p.put(entry.getKey(), LogEnum.valueOf(entry.getValue()));
        }
        return p;
    }

    private List<Object> getRange(List<String> list) {
        ArrayList<Object> range = new ArrayList<Object>(list.size());
        for (String s : list) {
            range.add(D.t((Object)s));
        }
        return range;
    }

    @Override
    public String getJobSummary() {
        return ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7\u5df2\u5b8c\u6210\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"DeleteLogJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    @Override
    public String refreshProgress() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.index.get()).append('/').append(this.counts);
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.index.get();
        String desc = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7\u6b63\u5728\u8fdb\u884c\uff1a%1$s/%2$s", (String)"DeleteLogJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), completed, this.counts);
        return new Job.Progress(this.counts, completed, desc);
    }

    @Override
    public final long getOwnerId() {
        return Hash.mur64((byte[])FACTORY.getType().getBytes(D.UTF_8));
    }

    @Override
    public String getParam() {
        return this.params;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }
}

