/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mapping.bean;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.mapping.util.PropertyUtil;

public class PropertyModel {
    private String name;
    private String fullname;
    private String label;
    private String detailedLabel;
    private String detailedDesc;
    private String type;
    private long groupId;
    private boolean isEntry;
    private boolean isRef;
    private String schema;
    private boolean isPrimaryKey;
    private boolean required;
    private long metaId;
    private String metaType;
    private Map<String, PropertyModel> childProps = new LinkedHashMap<String, PropertyModel>();

    public PropertyModel(String namePrefix, String labelPrefix, long groupId, String metaType, DynamicObject prop) {
        this(namePrefix, labelPrefix, groupId, metaType, prop.getString("prop_name"), prop.getString("prop_label"), prop.getString("data_type"), prop.getString("data_schema"), prop.getBoolean("is_primary_key"), prop.getBoolean("required"));
    }

    public PropertyModel(String namePrefix, String labelPrefix, long groupId, String metaType, String name, String label, String dataType, String dataSchema, boolean isPrimaryKey, boolean required) {
        this.groupId = groupId;
        this.metaType = metaType;
        this.label = label;
        this.detailedLabel = labelPrefix + this.label;
        this.type = dataType;
        this.schema = dataSchema;
        this.isPrimaryKey = isPrimaryKey;
        this.required = required;
        this.detailedDesc = this.initDetailedDesc();
        this.isEntry = "ENTRIES".equals(this.type) || "SubHeadEntity".equals(this.type);
        this.isRef = "REF".equals(this.type);
        this.name = name;
        this.appendNumberFieldIfIsRef();
        this.fullname = namePrefix + this.name;
        if (this.isEntry) {
            this.initChildProps(groupId, dataSchema);
        }
    }

    private void appendNumberFieldIfIsRef() {
        String numberFieldName;
        if (this.isRef && (numberFieldName = PropertyUtil.findNumberFieldName(this.groupId, this.schema)) != null) {
            this.name = this.name + "." + numberFieldName;
        }
    }

    private void initChildProps(long groupId, String number) {
        DynamicObject entryMeta = PropertyUtil.getMetaByNumber(groupId, number);
        this.metaId = entryMeta.getLong("id");
        DynamicObjectCollection propEntries = entryMeta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject propEntry : propEntries) {
            if (PropertyUtil.isAttachField(propEntry)) continue;
            PropertyModel propertyModel = new PropertyModel(this.fullname + ".", this.detailedLabel + ".", groupId, entryMeta.getString("type"), propEntry);
            this.childProps.put(propertyModel.getName(), propertyModel);
        }
    }

    public String getDetailedDesc() {
        return this.detailedDesc;
    }

    private String initDetailedDesc() {
        StringBuilder sb = new StringBuilder(this.detailedLabel);
        sb.append(" - ").append(this.type);
        if (this.isPrimaryKey) {
            sb.append(ResManager.loadKDString((String)" - \u4e3b\u952e", (String)"PropertyModel_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else if (this.required) {
            sb.append(ResManager.loadKDString((String)" - \u5fc5\u586b", (String)"PropertyModel_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getType() {
        return this.type;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public boolean isAttachmentField() {
        return "bd_attachment".equals(this.schema) || "bos_attachment".equals(this.schema);
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public long getMetaId() {
        return this.metaId;
    }

    public boolean isRef() {
        return this.isRef;
    }

    public String getDetailedLabel() {
        return this.detailedLabel;
    }

    public Map<String, PropertyModel> getChildProps() {
        return Collections.unmodifiableMap(this.childProps);
    }
}

